<?php
/**
 * @package SampleRender
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();
 
require_once XOOPS_ROOT_PATH . "/core/XCube_RenderSystem.class.php";

class SampleRender_ThemeRenderTarget extends XCube_RenderTarget
{
	var $_mSendHeaderFlag = false;

	function SampleRender_ThemeRenderTarget()
	{
		parent::XCube_RenderTarget();
		$this->setAttribute('legacy_buffertype', XCUBE_RENDER_TARGET_TYPE_THEME);
	}

	function _sendHeader()
	{
		header('Content-Type:text/html; charset=' . _CHARSET);
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0', false);
		header('Pragma: no-cache');
		
		$this->_mSendHeaderFlag = true;
	}

	function setResult($result)
	{
		parent::setResult($result);
		if(!$this->_mSendHeaderFlag) {
			$this->_sendHeader();
		}

		print $result;
	}
}


class SampleRender_RenderSystem extends XCube_RenderSystem
{
	function prepare()
	{
		
	}
	
	function &getThemeRenderTarget($dialogMode)
	{
		$target =& new SampleRender_ThemeRenderTarget();
		return $target;
	}
	
	function render(&$target)
	{
		if ($target->getAttribute('legacy_buffertype') == XCUBE_RENDER_TARGET_TYPE_THEME) {
			$this->renderTheme($target);
		}
	}
	
	function renderTheme(&$target)
	{
		$smarty =& new Smarty();
		$smarty->compile_dir = XOOPS_COMPILE_PATH;
		$smarty->template_dir = XOOPS_THEME_PATH . '/' . $target->getTemplateName();

		foreach($target->getAttributes() as $name => $value) {
			$smarty->assign($name, $value);
		}
		
		$smarty->assign('themeURL', XOOPS_THEME_URL . '/' . $target->getTemplateName());
		
		$root =& XCube_Root::getSingleton();
		$smarty->assign('legacy_sitename', $root->mContext->getAttribute('legacy_sitename'));
		$smarty->assign('legacy_pagetitle', $root->mContext->getAttribute('legacy_pagetitle'));
		$smarty->assign('legacy_slogan', $root->mContext->getAttribute('legacy_slogan'));

		$smarty->assign('xoops_url', XOOPS_URL);
		
		//
		// Push blocks
		//
		$assignNameMap = array(
			XOOPS_SIDEBLOCK_LEFT => 'SampleRender_leftBlocks',
			XOOPS_CENTERBLOCK_LEFT => 'SampleRender_centerleftBlocks',
			XOOPS_CENTERBLOCK_RIGHT => 'SampleRender_centerrightBlocks',
			XOOPS_CENTERBLOCK_CENTER => 'SampleRender_centerBlocks',
			XOOPS_SIDEBLOCK_RIGHT => 'SampleRender_rightBlocks'
		);

		foreach($assignNameMap as $idx => $prefix) {
			if (isset($root->mContext->mAttributes['legacy_BlockShowFlags'][$idx])) {
				$smarty->assign($prefix . '_isShow', $root->mContext->mAttributes['legacy_BlockShowFlags'][$idx]);
				$smarty->assign($prefix, $root->mContext->mAttributes['legacy_BlockContents'][$idx]);
			}
		}
		
		$result = $smarty->fetch('theme.html');
		
		$target->setResult($result);
	}
}

?>