<?php
/**
 * @package SampleRender
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_Theme.class.php";

class SampleRender_DelegateFunctions
{
	/**
	 * Search themes that Legacy_RenderSystem can render in file system.
	 */	
	function getInstalledThemes(&$results)
	{
		if ($handler = opendir(XOOPS_THEME_PATH)) {
			while (($dirname = readdir($handler)) !== false) {
				if ($dirname == "." || $dirname == "..") {
					continue;
				}

				$themeDir = XOOPS_THEME_PATH . "/" . $dirname;
				if (is_dir($themeDir)) {
					$theme =& new XCube_Theme();
					$theme->mDirname = $dirname;
					
					if ($theme->loadManifesto($themeDir . "/manifesto.ini.php")) {
						if ($theme->mRenderSystemName == 'SampleRender_RenderSystem') {
							$results[] =& $theme;
						}
					}
					
					unset($theme);
				}
			}
			closedir($handler);
		}
	}
}

?>