<?php
/**
 * @package Pm
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Sample class
 */
class Message_Service extends XCube_Service
{
	var $mServiceName = "Pm_Service";
	var $mNameSpace = "Message";
	var $mClassName = "Message_Service";
	
	function prepare()
	{
		$this->addFunction(S_PUBLIC_FUNC('string getPmInboxUrl(int uid)'));
		$this->addFunction(S_PUBLIC_FUNC('string getPmliteUrl(int fromUid, int toUid)'));
		$this->addFunction(S_PUBLIC_FUNC('int getCountUnreadPM(int uid)'));
	}
	
	function getPmInboxUrl()
	{
		$root =& XCube_Root::getSingleton();
		$uid = $root->mContext->mRequest->getRequest('uid');
		
		if ($uid > 0) {
			return XOOPS_URL . "/modules/message/index.php";
		}
		
		return "";
	}
	
	function getPmliteUrl()
	{
		$root =& XCube_Root::getSingleton();
		
		$fromUid = $root->mContext->mRequest->getRequest('fromUid');
		$toUid = $root->mContext->mRequest->getRequest('toUid');

		if ($fromUid > 0 && $toUid > 0) {
			return XOOPS_URL . "/pmlite.php?uid=${toUid}";
		}
		
		return "";
	}
	
	function getCountUnreadPM()
	{
		$root =& XCube_Root::getSingleton();
		$uid = $root->mContext->mRequest->getRequest('uid');
		
		if ($uid > 0) {
			$handler =& xoops_getmodulehandler('inbox', 'message');
			$criteria =& new CriteriaCompo();
			$criteria->add(new Criteria('uid', $uid));
			$criteria->add(new Criteria('is_read', 0));
			return $handler->getCount($criteria);
		}
		
		return 0;
	}
}

?>