<?php

if (!defined('XOOPS_ROOT_PATH')) die();

class Message_Preload extends XCube_ActionFilter
{
	function preBlockFilter()
	{
		require_once XOOPS_MODULE_PATH . "/message/service/Service.class.php";
		$service =& new Message_Service();
		$service->prepare();
		
		$this->mRoot->mServiceManager->addService('privateMessage', $service);
		
		$root =& XCube_Root::getSingleton();
		$root->mDelegateManager->add('Legacypage.Viewpmsg.Access', "Message_Preload::accessToViewpmsg");
		$root->mDelegateManager->add('Legacypage.Readpmsg.Access', "Message_Preload::accessToReadpmsg");
		$root->mDelegateManager->add('Legacypage.Pmlite.Access', "Message_Preload::accessToPmlite");
		$root->mDelegateManager->add('Legacy.Event.GetHandler', "Message_Preload::getHandler");
	}

	function accessToReadpmsg()
	{
		$msg_id = xoops_getrequest('msg_id');
		
		$handler =& xoops_getmodulehandler('inbox', 'message');
		$objArr =& $handler->getObjects(new Criteria('old_id', $msg_id));
		
		if (count($objArr) > 0) {
			$root =& XCube_Root::getSingleton();
			$root->mController->executeForward(XOOPS_MODULE_URL . '/message/index.php?action=InboxView&inbox_id=' . $msg_id);
		}
	}

	function accessToViewpmsg()
	{
		$root =& XCube_Root::getSingleton();
		$root->mController->executeForward(XOOPS_MODULE_URL . '/message/index.php');
	}
	
	function accessToPmlite()
	{
		//
		// Boot the action frame of the user module directly.
		//
		$root =& XCube_Root::getSingleton();
		$root->mController->executeHeader();
		
		$root->mController->setupModuleContext('message');
		$root->mLanguageManager->loadModuleMessageCatalog('message');
		
		$root->mController->setDialogMode(true);

		require_once XOOPS_MODULE_PATH . "/message/class/ActionFrame.class.php";

		$moduleRunner =& new Message_ActionFrame(false);
		$moduleRunner->setActionName('pmlite');

		$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));

		$root->mController->execute();
		
		$root->mController->executeView();
	}
	
	function getHandler(&$handler, $name, $optional)
	{
		if ($name == 'privmessage') {
			require_once XOOPS_ROOT_PATH . "/modules/message/kernel/privmessage.class.php";
			
			$root =& XCube_Root::getSingleton();
			
			$handler = new Message_PrivateMessageHandler($root->mController->mDB);
		}
	}
}

?>