<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/kernel/privmessage.php";

class Message_PrivateMessage extends XoopsPrivmessage
{
	function assignVarsFromInbox($row)
	{
		$this->set('msg_id', $row['inbox_id']);
		$this->set('subject', $row['title']);
		$this->set('from_userid', $row['from_uid']);
		$this->set('to_userid', $row['uid']);
		$this->set('msg_time', $row['create_unixtime']);
		$this->set('msg_text', $row['message']);
		$this->set('read_msg', $row['is_read']);
	}
}

class Message_PrivateMessageHandler extends XoopsPrivmessageHandler
{
	function &create($isNew = true)
	{
		$pm =& new Message_PrivateMessage();
		if ($isNew) {
			$pm->setNew();
		}
		
		return $pm;
	}
	
	function &get($id)
	{
		$ret = false;
		$id = intval($id);
		if ($id > 0) {
			$sql = 'SELECT * FROM ' . $this->db->prefix('message_inbox') . ' WHERE inbox_id=' . $id;
			if ($result = $this->db->query($sql)) {
				if ($this->db->getRowsNum($result) == 1) {
					$pm =& new Message_PrivateMessage();
					$pm->assignVarsFromInbox($this->db->fetchArray($result));
					return $pm;
				}
			}
		}
		
		return $ret;
	}
	
	function insert(&$pm, $forceFlag = true)
	{
		$handler =& xoops_getmodulehandler('inbox', 'message');
		$message =& $handler->create();
		
		$message->set('uid', $pm->get('to_userid'));
		$message->set('from_uid', $pm->get('from_userid'));
		$message->set('title', $pm->get('subject'));
		$message->set('message', $pm->get('msg_text'));
		$message->set('create_unixtime', $pm->get('msg_time'));
		$message->set('is_read', $pm->get('read_msg'));
		
		if ($handler->insert($message, $forceFlag)) {
			$pm->set('msg_id', $pm->get('inbox_id'));
			return true;
		}
		
		return false;
	}
	
	function delete(&$pm)
	{
		$handler =& xoops_getmodulehandler('inbox', 'message');
		$message =& $handler->get($pm->get('msg_id'));
		
		if ($message != null) {
			return $handler->delete($message);
		}
		
		return false;
	}
	
	function &getObjects($criteria = null, $id_as_key = false)
	{
		$handler =& xoops_getmodulehandler('inbox', 'message');
		$this->_convertCriteria($criteria);
		$messageArr =& $handler->getObjects($criteria);
		
		$ret = array();
		foreach (array_keys($messageArr) as $idx) {
			$obj =& $this->create();
			$obj->assignVarsFromInbox($messageArr[$idx]);
			
			if ($id_as_key) {
				$ret[$messageArr[$idx]->get('inbox_id')] =& $obj;
			}
			else {
				$ret[] =& $obj;
			}
			
			unset($obj);
		}
		
		return $ret;
	}
	
	function getCount($criteria = null)
	{
		$this->_convertCriteria($criteria);
		$handler =& xoops_getmodulehandler('inbox', 'message');
		return $handler->getCount($criteria);
	}
	
	function setRead(&$pm)
	{
		$handler =& xoops_getmodulehandler('inbox', 'message');
		$message =& $handler->get($pm->get('msg_id'));
		
		if ($message != null) {
			$message->set('is_read', 1);
			if ($handler->insert($message)) {
				$pm->set('read_msg', 1);
				return true;
			}
		}
		
		return false;
	}
	
	function _convertCriteria(&$criteria)
	{
		$map = array(
			'msg_id' => 'inbox_id',
			'subject' => 'title',
			'from_userid' => 'from_uid',
			'to_userid' => 'uid',
			'msg_time' => 'create_unixtime',
			'msg_text' => 'message',
			'read_msg' => 'is_read'
		);
		
		if (is_a($criteria, 'Criteria')) {
			if (isset($map[$criteria->column])) {
				$criteria->column = $map[$criteria->column];
			}
			
			if (count($criteria->sort) && isset($map[$criteria->sort[0]])) {
				$criteria->sort[0] = $map[$criteria->sort[0]];
			}
		}
		elseif (is_a($criteria, 'CriteriaCompo')) {
			foreach (array_keys($criteria->criteriaElements) as $idx) {
				$this->_convertCriteria($criteria->criteriaElements[$idx]);
			}
		}
	}
}
?>