<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractFilterForm.class.php";

define('SENDBOX_SORT_KEY_SENDBOX_ID', 1);
define('SENDBOX_SORT_KEY_UID', 2);
define('SENDBOX_SORT_KEY_TO_UID', 3);
define('SENDBOX_SORT_KEY_TITLE', 4);
define('SENDBOX_SORT_KEY_MESSAGE', 5);
define('SENDBOX_SORT_KEY_CREATE_UNIXTIME', 6);

define('SENDBOX_SORT_KEY_DEFAULT', SENDBOX_SORT_KEY_SENDBOX_ID);
define('SENDBOX_SORT_KEY_MAXVALUE', 6);

class Message_SendboxFilterForm extends Message_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		SENDBOX_SORT_KEY_DEFAULT => 'sendbox_id',
		SENDBOX_SORT_KEY_SENDBOX_ID => 'sendbox_id',
		SENDBOX_SORT_KEY_UID => 'uid',
		SENDBOX_SORT_KEY_TO_UID => 'to_uid',
		SENDBOX_SORT_KEY_TITLE => 'title',
		SENDBOX_SORT_KEY_MESSAGE => 'message',
		SENDBOX_SORT_KEY_CREATE_UNIXTIME => 'create_unixtime'
	);
	var $_mCriteria = null;

	function getDefaultSortKey()
	{
		return -SENDBOX_SORT_KEY_CREATE_UNIXTIME;
	}

	function fetch()
	{
		parent::fetch();
	
		$root =& XCube_Root::getSingleton();
		if (is_object($root->mContext->mXoopsUser)) {
			$this->_mCriteria->add(new Criteria('uid', $root->mContext->mXoopsUser->get('uid')));
		}
		else {
			$this->_mCriteria->add(new Criteria('uid', 0));
		}
		
		if (isset($_REQUEST['to_uid'])) {
			$this->mNavi->addExtra('to_uid', xoops_getrequest('to_uid'));
			$this->_mCriteria->add(new Criteria('to_uid', xoops_getrequest('to_uid')));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
