<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractFilterForm.class.php";

define('INBOX_SORT_KEY_INBOX_ID', 1);
define('INBOX_SORT_KEY_UID', 2);
define('INBOX_SORT_KEY_FROM_UID', 3);
define('INBOX_SORT_KEY_TITLE', 4);
define('INBOX_SORT_KEY_MESSAGE', 5);
define('INBOX_SORT_KEY_CREATE_UNIXTIME', 6);
define('INBOX_SORT_KEY_IS_READ', 7);

define('INBOX_SORT_KEY_DEFAULT', INBOX_SORT_KEY_INBOX_ID);
define('INBOX_SORT_KEY_MAXVALUE', 7);

class Message_InboxFilterForm extends Message_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		INBOX_SORT_KEY_DEFAULT => 'inbox_id',
		INBOX_SORT_KEY_INBOX_ID => 'inbox_id',
		INBOX_SORT_KEY_UID => 'uid',
		INBOX_SORT_KEY_FROM_UID => 'from_uid',
		INBOX_SORT_KEY_TITLE => 'title',
		INBOX_SORT_KEY_MESSAGE => 'message',
		INBOX_SORT_KEY_CREATE_UNIXTIME => 'create_unixtime',
		INBOX_SORT_KEY_IS_READ => 'is_read'
	);
	var $_mCriteria = null;

	function getDefaultSortKey()
	{
		return -INBOX_SORT_KEY_CREATE_UNIXTIME;
	}

	function fetch()
	{
		parent::fetch();
		
		$root =& XCube_Root::getSingleton();
		if (is_object($root->mContext->mXoopsUser)) {
			$this->_mCriteria->add(new Criteria('uid', $root->mContext->mXoopsUser->get('uid')));
		}
		else {
			$this->_mCriteria->add(new Criteria('uid', 0));
		}
		
		if (isset($_REQUEST['from_uid'])) {
			$this->mNavi->addExtra('from_uid', xoops_getrequest('from_uid'));
			$this->_mCriteria->add(new Criteria('from_uid', xoops_getrequest('from_uid')));
		}
		
		if (isset($_REQUEST['is_read'])) {
			$this->mNavi->addExtra('is_read', xoops_getrequest('is_read'));
			$this->_mCriteria->add(new Criteria('is_read', xoops_getrequest('is_read')));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
