<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/legacy/class/Legacy_Validator.class.php";

class Message_InboxEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.message.InboxEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['inbox_id'] =& new XCube_IntProperty('inbox_id');
		$this->mFormProperties['uid'] =& new XCube_IntProperty('uid');
		$this->mFormProperties['title'] =& new XCube_StringProperty('title');
		$this->mFormProperties['message'] =& new XCube_TextProperty('message');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['inbox_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['inbox_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['inbox_id']->addMessage('required', _MD_MESSAGE_ERROR_REQUIRED, _MD_MESSAGE_LANG_INBOX_ID);
	
		$this->mFieldProperties['uid'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['uid']->setDependsByArray(array('required'));
		$this->mFieldProperties['uid']->addMessage('required', _MD_MESSAGE_ERROR_REQUIRED, _MD_MESSAGE_LANG_TO);
	
		$this->mFieldProperties['title'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['title']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['title']->addMessage('required', _MD_MESSAGE_ERROR_REQUIRED, _MD_MESSAGE_LANG_SUBJECT, '255');
		$this->mFieldProperties['title']->addMessage('maxlength', _MD_MESSAGE_ERROR_MAXLENGTH, _MD_MESSAGE_LANG_SUBJECT, '255');
		$this->mFieldProperties['title']->addVar('maxlength', '255');
	
		$this->mFieldProperties['message'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['message']->setDependsByArray(array('required'));
		$this->mFieldProperties['message']->addMessage('required', _MD_MESSAGE_ERROR_REQUIRED, _MD_MESSAGE_LANG_MESSAGE);
	}

	function validateUid()
	{
		$handler =& xoops_gethandler('user');
		$user =& $handler->get($this->get('uid'));
		if (!is_object($user)) {
			$this->addErrorMessage(XCube_Utils::formatMessage(_MD_MESSAGE_ERROR_OBJECTEXIST, _MD_MESSAGE_LANG_TO));
		}
	}
	
	function load(&$obj)
	{
		$this->set('inbox_id', $obj->get('inbox_id'));
		$this->set('uid', $obj->get('uid'));
		$this->set('title', $obj->get('title'));
		$this->set('message', $obj->get('message'));
	}

	function update(&$obj)
	{
		$obj->set('inbox_id', $this->get('inbox_id'));
		$obj->set('uid', $this->get('uid'));
		$obj->set('title', $this->get('title'));
		$obj->set('message', $this->get('message'));
		$obj->set('create_unixtime', time());
	}
}

?>
