<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractFilterForm.class.php";

define('DRAFTBOX_SORT_KEY_DRAFTBOX_ID', 1);
define('DRAFTBOX_SORT_KEY_UID', 2);
define('DRAFTBOX_SORT_KEY_TO_UID', 3);
define('DRAFTBOX_SORT_KEY_TITLE', 4);
define('DRAFTBOX_SORT_KEY_MESSAGE', 5);
define('DRAFTBOX_SORT_KEY_CREATE_UNIXTIME', 6);

define('DRAFTBOX_SORT_KEY_DEFAULT', DRAFTBOX_SORT_KEY_DRAFTBOX_ID);
define('DRAFTBOX_SORT_KEY_MAXVALUE', 6);

class Message_DraftboxFilterForm extends Message_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		DRAFTBOX_SORT_KEY_DEFAULT => 'draftbox_id',
		DRAFTBOX_SORT_KEY_DRAFTBOX_ID => 'draftbox_id',
		DRAFTBOX_SORT_KEY_UID => 'uid',
		DRAFTBOX_SORT_KEY_TO_UID => 'to_uid',
		DRAFTBOX_SORT_KEY_TITLE => 'title',
		DRAFTBOX_SORT_KEY_MESSAGE => 'message',
		DRAFTBOX_SORT_KEY_CREATE_UNIXTIME => 'create_unixtime'
	);
	var $_mCriteria = null;

	function getDefaultSortKey()
	{
		return -DRAFTBOX_SORT_KEY_CREATE_UNIXTIME;
	}

	function fetch()
	{
		parent::fetch();
	
		$root =& XCube_Root::getSingleton();
		if (is_object($root->mContext->mXoopsUser)) {
			$this->_mCriteria->add(new Criteria('uid', $root->mContext->mXoopsUser->get('uid')));
		}
		else {
			$this->_mCriteria->add(new Criteria('uid', 0));
		}
	
		if (isset($_REQUEST['to_uid'])) {
			$this->mNavi->addExtra('to_uid', xoops_getrequest('to_uid'));
			$this->_mCriteria->add(new Criteria('to_uid', xoops_getrequest('to_uid')));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
