<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class MessageSendboxObject extends XoopsSimpleObject
{
	function MessageSendboxObject()
	{
		$this->initVar('sendbox_id', XOBJ_DTYPE_INT, '', true);
		$this->initVar('uid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('to_uid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('message', XOBJ_DTYPE_TEXT, '', true);
		$this->initVar('create_unixtime', XOBJ_DTYPE_INT, time(), true);
	}
	
	function loadFromInbox(&$obj)
	{
		$this->set('uid', $obj->get('from_uid'));
		$this->set('to_uid', $obj->get('uid'));
		$this->set('title', $obj->get('title'));
		$this->set('message', $obj->get('message'));
		$this->set('create_unixtime', $obj->get('create_unixtime'));
	}
}

class MessageSendboxHandler extends XoopsObjectGenericHandler
{
	var $mTable = "message_sendbox";
	var $mPrimary = "sendbox_id";
	var $mClass = "MessageSendboxObject";
}

?>
