<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class MessageInboxObject extends XoopsSimpleObject
{
	function MessageInboxObject()
	{
		$this->initVar('inbox_id', XOBJ_DTYPE_INT, '', true);
		$this->initVar('old_id', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('uid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('from_uid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('message', XOBJ_DTYPE_TEXT, '', true);
		$this->initVar('create_unixtime', XOBJ_DTYPE_INT, time(), true);
		$this->initVar('is_read', XOBJ_DTYPE_BOOL, '0', true);
	}
	
	function loadFromDraft(&$obj)
	{
		$this->set('from_uid', $obj->get('uid'));
		$this->set('uid', $obj->get('to_uid'));
		$this->set('title', $obj->get('title'));
		$this->set('message', $obj->get('message'));
	}
}

class MessageInboxHandler extends XoopsObjectGenericHandler
{
	var $mTable = "message_inbox";
	var $mPrimary = "inbox_id";
	var $mClass = "MessageInboxObject";
	
	function send(&$obj, $forceFlag = false)
	{
		if ($this->insert($obj, $forceFlag)) {
			$handler =& xoops_getmodulehandler('sendbox', 'message');
			$send =& $handler->create();
			$send->loadFromInbox($obj);
			$handler->insert($send);
			
			return true;
		}
		
		return false;
	}
}

?>
