<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class MessageDraftboxObject extends XoopsSimpleObject
{
	function MessageDraftboxObject()
	{
		$this->initVar('draftbox_id', XOBJ_DTYPE_INT, '', true);
		$this->initVar('uid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('to_uid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('message', XOBJ_DTYPE_TEXT, '', true);
		$this->initVar('create_unixtime', XOBJ_DTYPE_INT, time(), true);
	}
	
	function loadFromInbox(&$obj)
	{
		$this->set('uid', $obj->get('from_uid'));
		$this->set('to_uid', $obj->get('uid'));
		$this->set('title', $obj->get('title'));
		$this->set('message', $obj->get('message'));
	}
}

class MessageDraftboxHandler extends XoopsObjectGenericHandler
{
	var $mTable = "message_draftbox";
	var $mPrimary = "draftbox_id";
	var $mClass = "MessageDraftboxObject";
}

?>
