<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

define ("MESSAGE_FRAME_PERFORM_SUCCESS", 1);
define ("MESSAGE_FRAME_PERFORM_FAIL", 2);
define ("MESSAGE_FRAME_INIT_SUCCESS", 3);

define ("MESSAGE_FRAME_VIEW_NONE", 1);
define ("MESSAGE_FRAME_VIEW_SUCCESS", 2);
define ("MESSAGE_FRAME_VIEW_ERROR", 3);
define ("MESSAGE_FRAME_VIEW_INDEX", 4);
define ("MESSAGE_FRAME_VIEW_INPUT", 5);
define ("MESSAGE_FRAME_VIEW_PREVIEW", 6);
define ("MESSAGE_FRAME_VIEW_CANCEL", 7);

class Message_ActionFrame
{
	var $mActionName = null;
	var $mAction = null;
	var $mAdminFlag = null;

	function Message_ActionFrame($admin)
	{
		$this->mAdminFlag = $admin;
	}

	function setActionName($name)
	{
		$this->mActionName = $name;
	}

	function execute(&$controller)
	{
		if (!preg_match("/^\w+$/", $this->mActionName)) {
			$this->doActionNotFoundError();
			die();
		}
	
		//
		// Create action object by mActionName
		//
		$className = "Message_" . ucfirst($this->mActionName) . "Action";
		$fileName = ucfirst($this->mActionName) . "Action";
		if ($this->mAdminFlag) {
			$fileName = XOOPS_MODULE_PATH . "/message/admin/actions/${fileName}.class.php";
		}
		else {
			$fileName = XOOPS_MODULE_PATH . "/message/actions/${fileName}.class.php";
		}
	
		if (!file_exists($fileName)) {
			$this->doActionNotFoundError();
			die();
		}
	
		require_once $fileName;
	
		if (class_exists($className)) {
			$this->mAction =& new $className();
		}
	
		if (!is_object($this->mAction)) {
			$this->doActionNotFoundError();
			die();
		}
	
		if ($this->mAction->isMemberOnly() && !$controller->mRoot->mContext->mUser->isInRole('Site.RegisteredUser')) {
			$this->doPermissionError();
			die();
		}
	
		if ($this->mAction->isAdminOnly() && !$controller->mRoot->mContext->mUser->isInRole('Module.message.Admin')) {
			$this->doPermissionError();
			die();
		}
	
		if ($this->mAction->prepare($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModuleConfig) === false) {
			$this->doPreparationError();
			die();
		}
	
		if (!$this->mAction->hasPermission($controller->mRoot->mContext)) {
			$this->doPermissionError();
			return;
		}
	
		if (xoops_getenv("REQUEST_METHOD") == "POST") {
			$viewStatus = $this->mAction->execute($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModuleConfig);
		}
		else {
			$viewStatus = $this->mAction->getDefaultView($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModuleConfig);
		}
	
		switch($viewStatus) {
			case MESSAGE_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModule->getRenderTarget());
				break;
		
			case MESSAGE_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModule->getRenderTarget());
				break;
		
			case MESSAGE_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModule->getRenderTarget());
				break;
		
			case MESSAGE_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModule->getRenderTarget());
				break;
		
			case MESSAGE_FRAME_VIEW_PREVIEW:
				$this->mAction->executeViewPreview($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModule->getRenderTarget());
				break;
		
			case MESSAGE_FRAME_VIEW_CANCEL:
				$this->mAction->executeViewCancel($controller, $controller->mRoot->mContext->mXoopsUser, $controller->mRoot->mContext->mModule->getRenderTarget());
				break;
		}
	}

	function doPermissionError()
	{
		XCube_DelegateUtils::call("Module.Message.Event.Exception.Permission");
		$root =& XCube_Root::getSingleton();
		$root->mController->executeForward(XOOPS_URL);
		return;
	}

	function doActionNotFoundError()
	{
		XCube_DelegateUtils::call("Module.Message.Event.Exception.ActionNotFound");
		$root =& XCube_Root::getSingleton();
		$root->mController->executeForward(XOOPS_URL);
		return;
	}

	function doPreparationError()
	{
		XCube_DelegateUtils::call("Module.Message.Event.Exception.Preparation");
		$root =& XCube_Root::getSingleton();
		$root->mController->executeForward(XOOPS_URL);
		return;
	}

	function checkPermission($name, $itemIds)
	{
	}
}

class Message_AbstractAction
{
	function Message_AbstractAction()
	{
	}

	function isMemberOnly()
	{
		return false;
	}

	function isAdminOnly()
	{
		return false;
	}

	function prepare(&$controller, &$xoopsUser)
	{
		return true;
	}

	function hasPermission(&$context)
	{
		return true;
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		return MESSAGE_FRAME_VIEW_NONE;
	}

	function execute(&$controller, &$xoopsUser)
	{
		return MESSAGE_FRAME_VIEW_NONE;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewPreview(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
	}
}

?>
