<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/modules/legacy/admin/class/ModuleInstaller.class.php";

class Message_Installer extends Legacy_ModuleInstaller
{
	function _processScript()
	{
		$this->mLog->addReport(_MI_MESSAGE_MESSAGE_MIGRATION_STARTED);
		
		//
		// Existed private messages may be too many. Fot that, this
		// process handles SQL directly.
		//
		
		$sql = "SELECT * FROM " . XOOPS_DB_PREFIX . "_priv_msgs";
		
		$root =& XCube_Root::getSingleton();
		$db =& $root->mController->getDB();
		
		$result = $db->query($sql);
		
		$inboxHandler =& xoops_getmodulehandler('inbox', 'message');
		$sendHandler =& xoops_getmodulehandler('sendbox', 'message');

		$successCount = 0;
		$errorCount = 0;
		
		while ($row = $db->fetchArray($result)) {
			$inbox = $inboxHandler->create();
			$inbox->set('old_id', $row['msg_id']);
			$inbox->set('uid', $row['to_userid']);
			$inbox->set('from_uid', $row['from_userid']);
			$inbox->set('title', $row['subject']);
			$inbox->set('message', $row['msg_text']);
			$inbox->set('is_read', $row['read_msg']);
			if ($inboxHandler->insert($inbox)) {
				$successCount++;
			}
			else {
				$errorCount++;
			}
			
			$send =& $sendHandler->create();
			$send->set('uid', $row['from_userid']);
			$send->set('to_uid', $row['to_userid']);
			$send->set('title', $row['subject']);
			$send->set('message', $row['msg_text']);
			if ($sendHandler->insert($send)) {
				$successCount++;
			}
			else {
				$errorCount++;
			}
		}
		
		$this->mLog->addReport(_MI_MESSAGE_MESSAGE_MIGRATION_FINISHED);
		$this->mLog->addReport(XCube_Utils::formatMessage(_MI_MESSAGE_MESSAGE_MIGRATION_SUCCESS, $successCount));
		$this->mLog->addReport(XCube_Utils::formatMessage(_MI_MESSAGE_MESSAGE_MIGRATION_FAIL, $errorCount));
	}
}

?>
