<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractViewAction.class.php";

class Message_SendboxViewAction extends Message_AbstractViewAction
{
	function isMemberOnly()
	{
		return true;
	}
	
	function hasPermission(&$context)
	{
		return $this->mObject->get('uid') == $context->mXoopsUser->get('uid');
	}
	
	function _getId()
	{
		return xoops_getrequest('sendbox_id');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('sendbox');
		return $handler;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_sendbox_view.html");
		#cubson::lazy_load('sendbox', $this->mObject);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=SendboxList", 1, _MD_MESSAGE_ERROR_CONTENT_IS_NOT_FOUND);
	}
}

?>
