<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/message/forms/SendboxDeleteForm.class.php";

class Message_SendboxDeleteAction extends Message_AbstractDeleteAction
{
	function isMemberOnly()
	{
		return true;
	}
	
	function hasPermission(&$context)
	{
		return $this->mObject->get('uid') == $context->mXoopsUser->get('uid');
	}
	
	function _getId()
	{
		return xoops_getrequest('sendbox_id');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('sendbox');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Message_SendboxDeleteForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_sendbox_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('sendbox', $this->mObject);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=SendboxList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=SendboxList", 1, _MD_MESSAGE_ERROR_DBUPDATE_FAILED);
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=SendboxList");
	}
}

?>
