<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractViewAction.class.php";

class Message_InboxViewAction extends Message_AbstractViewAction
{
	function isMemberOnly()
	{
		return true;
	}
	
	function hasPermission(&$context)
	{
		return $this->mObject->get('uid') == $context->mXoopsUser->get('uid');
	}
	
	function _getId()
	{
		return xoops_getrequest('inbox_id');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('inbox');
		return $handler;
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$result = parent::getDefaultView($controller, $xoopsUser);
		if ($result == MESSAGE_FRAME_VIEW_SUCCESS) {
			$this->mObject->set('is_read', 1);
			$this->mObjectHandler->insert($this->mObject, true);
		}
		
		return $result;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_inbox_view.html");
		#cubson::lazy_load('inbox', $this->mObject);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=InboxList", 1, _MD_MESSAGE_ERROR_CONTENT_IS_NOT_FOUND);
	}
}

?>
