<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/message/forms/InboxEditForm.class.php";

class Message_InboxEditAction extends Message_AbstractEditAction
{
	function isMemberOnly()
	{
		return true;
	}
	
	function _getId()
	{
		return xoops_getrequest('inbox_id');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('inbox', 'message');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Message_InboxEditForm();
		$this->mActionForm->prepare();
	}
	
	function _setupObject()
	{
		$id = $this->_getId();
		
		$this->mObjectHandler =& $this->_getHandler();
		$this->mObject =& $this->mObjectHandler->create();
		
		$root =& XCube_Root::getSingleton();
		
		$this->mObject->set('from_uid', $root->mContext->mXoopsUser->get('uid'));
		if (xoops_getrequest('uid') != 0) {
			$this->mObject->set('uid', xoops_getrequest('uid'));
		}
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		if ($this->mObject == null) {
			return MESSAGE_FRAME_VIEW_ERROR;
		}
		
		$reply =& $this->mObjectHandler->get(xoops_getrequest('inbox_id'));
		if ($reply != null && $reply->get('uid') == $xoopsUser->get('uid')) {
			$this->mObject->set('uid', $reply->get('from_uid'));
			$this->mObject->set('title', $reply->get('title'));
			//
			// Create subject
			//
			if (preg_match("/^Re\[(\d+)\]:(.*)/", $this->mObject->get('title'), $matches)) {
				$this->mObject->set('title', "Re[" . $matches[1] . "]: " . $matches[2]);
			}
			elseif (preg_match("/^Re:(.*)/", $this->mObject->get('title'), $matches)) {
				$this->mObject->set('title', "Re[2]: " . $matches[1]);
			}
			else {
				$this->mObject->set('title', "Re: " . $this->mObject->get('title'));
			}
			
			$this->mObject->set('message', '[quote]' . $reply->get('message') . '[/quote]');
		}
	
		$this->mActionForm->load($this->mObject);
	
		return MESSAGE_FRAME_VIEW_INPUT;
	}
	
	function _doExecute()
	{
		if (isset($_REQUEST['Legacy_Event_User_Modify'])) {
			return MESSAGE_FRAME_VIEW_INPUT;
		}
		elseif (isset($_REQUEST['Legacy_Event_User_Preview'])) {
			return MESSAGE_FRAME_VIEW_PREVIEW;
		}
		elseif (isset($_REQUEST['Legacy_Event_User_Draft'])) {
			$handler =& xoops_getmodulehandler('draftbox', 'message');
			$draft =& $handler->create();
			$draft->loadFromInbox($this->mObject);
			if ($handler->insert($draft)) {
				return MESSAGE_FRAME_VIEW_SUCCESS;
			}
		}
		elseif (isset($_REQUEST['Legacy_Event_User_Submit'])) {
			if ($this->mObjectHandler->send($this->mObject)) {
				return MESSAGE_FRAME_VIEW_SUCCESS;
			}
		}
		
		return MESSAGE_FRAME_VIEW_ERROR;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_inbox_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('inbox', $this->mObject)
		$render->setAttribute('object', $this->mObject);
		
		$handler =& xoops_gethandler('user');
		$userObjectArr =& $handler->getObjectsByLevel(0);
		$render->setAttribute("userList", $userObjectArr);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=InboxList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=InboxList", 1, _MD_MESSAGE_ERROR_DBUPDATE_FAILED);
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=InboxList");
	}
	
	function executeViewPreview(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_preview.html");
		#cubson::lazy_load('inbox', $this->mObject);
		$render->setAttribute('object', $this->mObject);
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('primaryKey', 'inbox_id');
		$render->setAttribute('uidKey', 'uid');
	}
}

?>
