<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/message/forms/DraftboxEditForm.class.php";

class Message_DraftboxEditAction extends Message_AbstractEditAction
{
	function isMemberOnly()
	{
		return true;
	}
	
	function hasPermission(&$context)
	{
		return $this->mObject->get('uid') == $context->mXoopsUser->get('uid');
	}
	
	function _getId()
	{
		return xoops_getrequest('draftbox_id');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('draftbox');
		return $handler;
	}

	function isEnableCreate()
	{
		return false;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Message_DraftboxEditForm();
		$this->mActionForm->prepare();
	}
	
	function _doExecute()
	{
		if (isset($_REQUEST['Legacy_Event_User_Modify'])) {
			return MESSAGE_FRAME_VIEW_INPUT;
		}
		elseif (isset($_REQUEST['Legacy_Event_User_Preview'])) {
			return MESSAGE_FRAME_VIEW_PREVIEW;
		}
		elseif (isset($_REQUEST['Legacy_Event_User_Draft'])) {
			if ($this->mObjectHandler->insert($this->mObject)) {
				return MESSAGE_FRAME_VIEW_SUCCESS;
			}
		}
		elseif (isset($_REQUEST['Legacy_Event_User_Submit'])) {
			$handler =& xoops_getmodulehandler('inbox');
			$message =& $handler->create();
			$message->loadFromDraft($this->mObject);
			if ($handler->send($message)) {
				$this->mObjectHandler->delete($this->mObject);
				return MESSAGE_FRAME_VIEW_SUCCESS;
			}
			else {
				return MESSAGE_FRAME_VIEW_ERROR;
			}
		}
		
		return MESSAGE_FRAME_VIEW_ERROR;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_draftbox_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('draftbox', $this->mObject)
		$render->setAttribute('object', $this->mObject);
		
		$handler =& xoops_gethandler('user');
		$userObjectArr =& $handler->getObjectsByLevel(0);
		$render->setAttribute("userList", $userObjectArr);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=DraftboxList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=DraftboxList", 1, _MD_MESSAGE_ERROR_DBUPDATE_FAILED);
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=DraftboxList");
	}
	
	function executeViewPreview(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_preview.html");
		#cubson::lazy_load('inbox', $this->mObject);
		$render->setAttribute('object', $this->mObject);
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('primaryKey', 'draftbox_id');
		$render->setAttribute('uidKey', 'to_uid');
	}
}

?>
