<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/message/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/message/forms/DraftboxDeleteForm.class.php";

class Message_DraftboxDeleteAction extends Message_AbstractDeleteAction
{
	function isMemberOnly()
	{
		return true;
	}
	
	function hasPermission(&$context)
	{
		return $this->mObject->get('uid') == $context->mXoopsUser->get('uid');
	}
	
	function _getId()
	{
		return xoops_getrequest('draftbox_id');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('draftbox');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Message_DraftboxDeleteForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("message_draftbox_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('draftbox', $this->mObject);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=DraftboxList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=DraftboxList", 1, _MD_MESSAGE_ERROR_DBUPDATE_FAILED);
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=DraftboxList");
	}
}

?>
