#!/bin/bash
# modified from 7font-search.sh in ptexlive-20100322

. ./common.sh $*

## fonts for Chinese and Korean
DLED=

# simplified Chinese
echo ; echo -e "\e[1;36mFonts for simplified Chinese\e[0m"
XDVICKT=x
if  kpsewhich -format 'truetype fonts' gbsn00lp.ttf &>/dev/null && \
    kpsewhich -format 'truetype fonts' wqy-zenhei.ttf &>/dev/null
then XDVICKT=ttf; fi
if  kpsewhich -format 'truetype fonts' AdobeSongStd-Light.otf &>/dev/null && \
    kpsewhich -format 'truetype fonts' AdobeHeitiStd-Regular.otf &>/dev/null
then XDVICKT=otf; fi
case $XDVICKT in
    x)
	echo "No fonts."
	sedwrite $TEXMF/xdvi/pxdvi.cfg  "s/gkai00mp.ttf/wqy-zenhei.ttf/"
	echo "supported fonts by this script:"
	echo "{ gbsn00lp.ttf (Arphic), wqy-zenhei.ttf (WenQuanYi) }"
	echo "{ AdobeSongStd-Light.otf, AdobeHeitiStd-Regular.otf (Adobe Reader 9 fontpack) }"
	;;
    ttf)
	echo "Following fonts will be used in pxdvi:"
	echo "  gbsn00lp.ttf, wqy-zenhei.ttf"
	sedwrite $TEXMF/xdvi/pxdvi.cfg  "s/gkai00mp.ttf/wqy-zenhei.ttf/"
	;;
    otf)
	echo "Following fonts will be used in pxdvi:"
	echo "  AdobeSongStd-Light.otf, AdobeHeitiStd-Regular.otf"
	sedwrite $TEXMF/xdvi/pxdvi.cfg  "s/gbsn00mp.ttf/AdobeSongStd-Light.otf/"
	sedwrite $TEXMF/xdvi/pxdvi.cfg  "s/gkai00mp.ttf/AdobeHeitiStd-Regular.otf/"
	;;
esac

# traditional Chinese
echo ; echo -e "\e[1;36mFonts for traditional Chinese\e[0m"
XDVICKT=x
if  kpsewhich -format 'truetype fonts' bsmi00lp.ttf &>/dev/null
then XDVICKT=ttf; fi 
if  kpsewhich -format 'truetype fonts' AdobeMingStd-Light.otf &>/dev/null
then XDVICKT=otf; fi
case $XDVICKT in
    x)
	echo "No font"
	echo "supported fonts by this script:"
	echo "  bsmi00lp.ttf (Arphic), AdobeMingStd-Light.otf (Adobe Reader 9 fontpack) }"
	;;
    ttf)
	echo "bsmi00lp.ttf will be used in pxdvi."
	;;
    otf)
	echo "AdobeMingStd-Light.otf will be used in pxdvi."
	sedwrite $TEXMF/xdvi/pxdvi.cfg  "s/bsmi00mp.ttf/AdobeMingStd-Light.otf/"
	;;
esac
sedwrite $TEXMF/xdvi/pxdvi.cfg  "s/bkai00mp.ttf/cwheib.ttf/"
echo "cwheib.ttf (cwTeX) will be used in pxdvi, but its existence"
echo "in your system is not checked by this script."

# Korean
echo ; echo -e "\e[1;36mFonts for Korean\e[0m"
XDVICKT=x
if  kpsewhich -format 'truetype fonts' UnBatang.ttf &>/dev/null
then XDVICKT=ttf; fi 
if  kpsewhich -format 'truetype fonts' AdobeMyungjoStd-Medium.otf &>/dev/null
then XDVICKT=otf; fi
case $XDVICKT in
    x)
	echo "No font for Korean."
	echo "supported fonts by this script:"
	echo "  UnBatang.ttf (un-fonts), AdobeMyungjoStd-Medium.otf (Adobe Reader 9 fontpack) }"
	;;
    ttf)
	echo "UnBatang.ttf will be used in pxdvi."
	;;
    otf)
	echo "AdobeMyungjoStd-Medium.otf will be used in pxdvi."
	sedwrite $TEXMF/xdvi/pxdvi.cfg  "s/UnBatang.ttf/AdobeMyungjoStd-Medium.otf/"
	;;
esac
echo "UnDotum.ttf (un-fonts) will be used in pxdvi, but its existence"
echo "in your system is not checked by this script."

exit 0
