#!/bin/bash
# modified from 7font-search.sh in ptexlive-20100322

. ./common.sh $*

# -----------------------------------
### font search and generate map files

mkptexmap() {
  #echo -e "\e[0;33m[writing]   \e[0m ptex-$1.map"
  cat <<EOF | sed "s+MIN+$2+;s+GOTH+$3+" > ptex-$1.map
%%
%% ASCII pTeX
%%

rml     H       MIN
rmlv    V       MIN
gbm     H       GOTH
gbmv    V       GOTH

%%
%% upTeX
%%

urml           UniJIS-UTF16-H          MIN
urmlv          UniJIS-UTF16-V          MIN
ugbm           UniJIS-UTF16-H          GOTH
ugbmv          UniJIS-UTF16-V          GOTH

uprml-h        UniJIS-UTF16-H          MIN
uprml-v        UniJIS-UTF16-V          MIN
upgbm-h        UniJIS-UTF16-H          GOTH
upgbm-v        UniJIS-UTF16-V          GOTH
uprml-hq       UniJIS-UCS2-H           MIN
upgbm-hq       UniJIS-UCS2-H           GOTH

EOF
  #echo -e "\e[0;33m[writing]   \e[0m utf-$1.map"
  cat <<EOF | sed "s+MIN+$2+;s+GOTH+$3+" > utf-$1.map
% UTF for dvipdfmx

unijmin-h   UniJIS-UTF16-H    MIN
unijmin-v   UniJIS-UTF16-V    MIN
cidmin-h    Identity-H        MIN
cidmin-v    Identity-V        MIN
hmr         H                 MIN
hmrv        V                 MIN

unijgoth-h  UniJIS-UTF16-H    GOTH
unijgoth-v  UniJIS-UTF16-V    GOTH
cidgoth-h   Identity-H        GOTH
cidgoth-v   Identity-V        GOTH
hkb         H                 GOTH
hkbv        V                 GOTH

EOF
  #echo -e "\e[0;33m[writing]   \e[0m otf-$1.map"
  cat <<EOF | sed "s+MIN+$2+;s+GOTH+$3+" \
    | sed "s+MIB+$4+;s+GTHB+$5+;s+MARU+$6+" \
    | sed "s+GTHE+$7+;s+MIL+$8+" > otf-$1.map
otf-ujmr-h  UniJIS-UTF16-H        MIN
otf-ujmr-v  UniJIS-UTF16-V        MIN
otf-cjmr-h  Identity-H      MIN
otf-cjmr-v  Identity-V  MIN
hminr-h     H MIN
hminr-v     V MIN
uphminr-h   UniJIS-UTF16-H        MIN
uphminr-v   UniJIS-UTF16-V        MIN

otf-ujgr-h  UniJIS-UTF16-H       GOTH
otf-ujgr-v  UniJIS-UTF16-V       GOTH
otf-cjgr-h  Identity-H     GOTH
otf-cjgr-v  Identity-V GOTH
hgothr-h    H GOTH
hgothr-v    V GOTH
uphgothr-h  UniJIS-UTF16-H       GOTH
uphgothr-v  UniJIS-UTF16-V       GOTH

otf-ujmb-h  UniJIS-UTF16-H    MIB
otf-ujmb-v  UniJIS-UTF16-V    MIB
otf-cjmb-h  Identity-H MIB
otf-cjmb-v  Identity-V MIB
hminb-h     H MIB
hminb-v     V MIB
uphminb-h   UniJIS-UTF16-H    MIB
uphminb-v   UniJIS-UTF16-V    MIB

otf-ujgb-h  UniJIS-UTF16-H    GTHB
otf-ujgb-v  UniJIS-UTF16-V    GTHB
otf-cjgb-h  Identity-H GTHB
otf-cjgb-v  Identity-V GTHB
hgothb-h    H GTHB
hgothb-v    V GTHB
uphgothb-h  UniJIS-UTF16-H    GTHB
uphgothb-v  UniJIS-UTF16-V    GTHB

hgotheb-h   H GTHE
hgotheb-v   V GTHE
uphgotheb-h UniJIS-UTF16-H GTHE
uphgotheb-v UniJIS-UTF16-V GTHE

otf-ujmgr-h UniJIS-UTF16-H       MARU
otf-ujmgr-v UniJIS-UTF16-V       MARU
otf-cjmgr-h Identity-H     MARU
otf-cjmgr-v Identity-V MARU
hmgothr-h   H MARU
hmgothr-v   V MARU
uphmgothr-h UniJIS-UTF16-H       MARU
uphmgothr-v UniJIS-UTF16-V       MARU

otf-ujml-h  UniJIS-UTF16-H        MIL
otf-ujml-v  UniJIS-UTF16-V        MIL
otf-cjml-h  Identity-H      MIL
otf-cjml-v  Identity-V  MIL
hminl-h     H MIL
hminl-v     V MIL
uphminl-h   UniJIS-UTF16-H        MIL
uphminl-v   UniJIS-UTF16-V        MIL
EOF
}


# usage: present minr gothr minb gothb mgoth gotheb minl
# return value: 0: not found, 2: minr and gothr are found, >=5
present() {
  mkptexmap $8 $1 $2 $3 $4 $5 $6 $7
  mingoth=0
  kpsewhich -format 'truetype fonts' $1 > /dev/null && mingoth=1
  kpsewhich -format 'opentype fonts' $1 > /dev/null && mingoth=1
  if [ $mingoth -ne 1 ] ; then return 0; fi
  kpsewhich -format 'truetype fonts' $2 > /dev/null && mingoth=2
  kpsewhich -format 'opentype fonts' $2 > /dev/null && mingoth=2
  if [ $mingoth -ne 2 ] ; then return 0; fi
  kpsewhich -format 'truetype fonts' $3 > /dev/null && mingoth=3
  kpsewhich -format 'opentype fonts' $3 > /dev/null && mingoth=3
  if [ $mingoth -ne 3 ] ; then return 2; fi
  kpsewhich -format 'truetype fonts' $4 > /dev/null && mingoth=4
  kpsewhich -format 'opentype fonts' $4 > /dev/null && mingoth=4
  if [ $mingoth -ne 4 ] ; then return 2; fi
  kpsewhich -format 'truetype fonts' $5 > /dev/null && mingoth=5
  kpsewhich -format 'opentype fonts' $5 > /dev/null && mingoth=5
  if [ $mingoth -ne 5 ] ; then return 2; fi
  kpsewhich -format 'truetype fonts' $6 > /dev/null && mingoth=6
  kpsewhich -format 'opentype fonts' $6 > /dev/null && mingoth=6
  if [ $mingoth -ne 6 ] ; then return 5; fi
  kpsewhich -format 'truetype fonts' $7 > /dev/null && mingoth=7
  kpsewhich -format 'opentype fonts' $7 > /dev/null && mingoth=7
  return $mingoth
}

dispfnt() {
  if [ $2 -eq 0 ]; then
    echo -e "$1 \e[0;31mNot found\e[0m"
  else
    FNTCAN="$FNTCAN$4/"
    if [ $2 -ge 5 ]; then
      echo -e "$1 \e[1;32m$2\e[0m fonts, $3"
    else
      echo -e "$1 \e[0;33m$2\e[0m fonts, $3"
    fi
  fi
}

mkdir -p $XMAP &>/dev/null
cd $XMAP
mkptexmap noEmbed    "!Ryumin-Light"     "!GothicBBB-Medium" \
    "!Ryumin-Light,Bold" "!GothicBBB-Medium,Bold" "!Ryumin-Light"\
    "!GothicBBB-Medium,Bold" "!Ryumin-Light"
cat <<EOF > otf-hiragino-ext.map
hiramin-w3-h Identity-H HiraMinPro-W3
hiramin-w6-h Identity-H HiraMinPro-W6
hirakaku-w3-h Identity-H HiraKakuPro-W3
hirakaku-w6-h Identity-H HiraKakuPro-W6
hiramaru-w4-h Identity-H HiraMaruPro-W4
EOF

echo; echo -e "\e[1;36mFound fonts: \e[0m"
mktexlsr $TEXMF &>/dev/null
FNTCAN=

present HiraMinPro-W3.otf HiraKakuPro-W3.otf \
        HiraMinPro-W6.otf HiraKakuPro-W6.otf HiraMaruPro-W4.otf \
        HiraKakuStd-W8.otf HiraMinPro-W2.otf hiragino
alt0=$?
present HiraMinProN-W3.otf HiraKakuProN-W3.otf \
        HiraMinProN-W6.otf HiraKakuProN-W6.otf HiraMaruProN-W4.otf \
        HiraKakuStdN-W8.otf HiraMinProN-W2.otf hiragino-N
alt1=$?
if [ $alt0 -gt $alt1 ]; then
  hiravar=hiragino; hirafnt=$alt0
else
  hiravar=hiragino-N; hirafnt=$alt1
fi
dispfnt "(H) Hiragino: " $hirafnt "($hiravar)" "H"

present A-OTF-RyuminPro-Light.otf A-OTF-GothicBBBPro-Medium.otf \
        A-OTF-FutoMinA101Pro-Bold.otf A-OTF-FutoGoB101Pro-Bold.otf A-OTF-Jun101Pro-Light.otf \
        A-OTF-MidashiGoPro-MB31.otf A-OTF-RyuminPro-Light.otf morisawa

alt0=$?
present A-OTF-RyuminPr6N-Light.otf A-OTF-GothicBBBPr6N-Medium.otf \
        A-OTF-FutoMinA101Pr6N-Bold.otf A-OTF-FutoGoB101Pr6N-Bold.otf A-OTF-Jun101Pr6N-Light.otf \
        A-OTF-MidashiGoPro-MB31.otf A-OTF-RyuminPro-Light.otf morisawa-Pr6N
alt1=$?
if [ $alt0 -gt $alt1 ]; then
  morivar=morisawa; morifnt=$alt0
else
  morivar=morisawa-Pr6N; morifnt=$alt1
fi
dispfnt "(M) Morisawa: " $morifnt "($morivar)" "M"

present KozMinPro-Regular-Acro.otf KozGoStd-Regular.otf \
        KozMinStd-Bold.otf KozGoStd-Bold.otf KozGoStd-Heavy.otf \
        KozGoStd-Heavy.otf KozGoStd-Light.otf kozuka
alt0=$?
present KozMinPro-Regular.otf KozGoPro-Regular.otf \
        KozMinPro-Bold.otf KozGoPro-Bold.otf KozGoPro-Heavy.otf \
        KozGoPro-Heavy.otf KozGoPro-Light.otf kozuka-Pro
alt1=$?
if [ $alt0 -gt $alt1 ]; then
  kozuvar=kozuka; kozufnt=$alt0
else
  kozuvar=kozuka-Pro; kozufnt=$alt1
fi
present KozMinPr6N-Regular.otf KozGoPr6N-Regular.otf \
        KozMinPr6N-Bold.otf KozGoPr6N-Bold.otf KozGoPr6N-Heavy.otf \
        KozGoPr6N-Heavy.otf KozGoPr6N-Light.otf kozuka-Pr6N
alt1=$?
if [ $alt1 -ge $kozufnt ]; then
  kozuvar=kozuka-Pr6N; kozufnt=$alt1
fi
dispfnt "(K) Kozuka:   " $kozufnt "($kozuvar)" "K"


present ipam.ttf ipag.ttf dummy dummy dummy dummy dummy ipa-ttf
ipatfnt=$?; dispfnt "(I) ipa-ttf:  " $ipatfnt "" "I"
mkptexmap ipa-ttf ipam.ttf ipag.ttf \
          "ipam.ttf,Bold" "ipag.ttf,Bold" "ipag.ttf" \
          "ipag.ttf,Bold" ipam.ttf

present ipam.otf ipag.otf dummy dummy dummy dummy dummy ipa-otf
ipaofnt=$?; dispfnt "(J) ipa-otf:  " $ipaofnt "" "J"
mkptexmap ipa-otf ipam.otf ipag.otf \
          "ipam.otf,Bold" "ipag.otf,Bold" "ipag.otf" \
          "ipag.otf,Bold" ipam.otf

mktexlsr $TEXMF &>/dev/null
PXDVIRML=
PXDVIGBM=

### UTF/OTF
echo; echo -e "\e[1;36mFonts for pTeX and UTF/OTF packages\e[0m"
echo "'N' means 'don't embed fonts'. "
echo -n "fonts for UTF/OTF packages (${FNTCAN}N) > "
read ANS

case $ANS in
    [Hh])
	if [ $hirafnt = 0 ]; then ANS=N; else
	    updmap-sys --nomkmap --enable KanjiMap otf-$hiravar.map &>/dev/null
	    updmap-sys --nomkmap --enable KanjiMap utf-$hiravar.map &>/dev/null
	    PXDVIRML=`cat utf-$hiravar.map |grep unijmin-h|sed "s/.*\ //"`
	    PXDVIGBM=`cat utf-$hiravar.map |grep unijgoth-h|sed "s/.*\ //"`
	    ANS=$hiravar
	fi
	;;
    [Mm])
	if [ $morifnt = 0 ]; then ANS=N; else
	    updmap-sys --nomkmap --enable KanjiMap otf-$morivar.map &>/dev/null
	    updmap-sys --nomkmap --enable KanjiMap utf-$morivar.map &>/dev/null
	    PXDVIRML=`cat utf-$morivar.map |grep unijmin-h|sed "s/.*\ //"`
	    PXDVIGBM=`cat utf-$morivar.map |grep unijgoth-h|sed "s/.*\ //"`
	    ANS=$morivar
	fi
	;;
    [Kk])
	if [ $kozufnt = 0 ]; then ANS=N; else
	    updmap-sys --nomkmap --enable KanjiMap otf-$kozuvar.map &>/dev/null
	    updmap-sys --nomkmap --enable KanjiMap utf-$kozuvar.map &>/dev/null
	    PXDVIRML=`cat utf-$kozuvar.map |grep unijmin-h|sed "s/.*\ //"`
	    PXDVIGBM=`cat utf-$kozuvar.map |grep unijgoth-h|sed "s/.*\ //"`
	    ANS=$kozuvar
	fi
	;;
    [Ii])
	if [ $ipatfnt = 0 ]; then ANS=N; else
	    updmap-sys --nomkmap --enable KanjiMap otf-ipa-ttf.map &>/dev/null
	    updmap-sys --nomkmap --enable KanjiMap utf-ipa-ttf.map &>/dev/null
	    PXDVIRML=ipam.ttf; PXDVIGBM=ipag.ttf; ANS=ipa-ttf
	fi
	;;
    [Jj])
	if [ $ipaofnt = 0 ]; then ANS=N; else
	    updmap-sys --nomkmap --enable KanjiMap otf-ipa-otf.map &>/dev/null
	    updmap-sys --nomkmap --enable KanjiMap utf-ipa-otf.map &>/dev/null
	    PXDVIRML=ipam.otf; PXDVIGBM=ipag.otf; ANS=ipa-otf
	fi
	;;
    [Nn]) ;;
    *) ANS=N;;
esac
case $ANS in
    [Nn])
	updmap-sys --nomkmap --enable KanjiMap otf-noEmbed.map &>/dev/null
	updmap-sys --nomkmap --enable KanjiMap utf-noEmbed.map &>/dev/null
	ANS=noEmbed;;
esac

### pTeX
if [ $ANS != "noEmbed" ] ; then
    echo; echo -n "fonts for pTeX (${FNTCAN}N) > "
    read ANS2
    
    case $ANS2 in
	[Hh])
	    if [ $hirafnt = 0 ]; then ANS2=N; else
		updmap-sys --nomkmap --enable KanjiMap ptex-$hiravar.map &>/dev/null
		PXDVIRML=`cat ptex-$hiravar.map |grep urmlv|sed "s/.*\ //"`
		PXDVIGBM=`cat ptex-$hiravar.map |grep ugbmv|sed "s/.*\ //"`
		ANS2=$hiravar
	    fi
	    ;;
	[Mm])
	    if [ $morifnt = 0 ]; then ANS2=N; else
		updmap-sys --nomkmap --enable KanjiMap ptex-$morivar.map &>/dev/null
		PXDVIRML=`cat ptex-$morivar.map |grep urmlv|sed "s/.*\ //"`
		PXDVIGBM=`cat ptex-$morivar.map |grep ugbmv|sed "s/.*\ //"`
		ANS2=$morivar
	    fi
	    ;;
	[Kk])
	    if [ $kozufnt = 0 ]; then ANS2=N; else
		updmap-sys --nomkmap --enable KanjiMap ptex-$kozuvar.map &>/dev/null
		PXDVIRML=`cat ptex-$kozuvar.map |grep urmlv|sed "s/.*\ //"`
		PXDVIGBM=`cat ptex-$kozuvar.map |grep ugbmv|sed "s/.*\ //"`
		ANS2=$kozuvar
	    fi
	    ;;
	[Ii])
	    if [ $ipatfnt = 0 ]; then ANS2=N; else
		updmap-sys --nomkmap --enable KanjiMap ptex-ipa-ttf.map &>/dev/null
		PXDVIRML=ipam.ttf; PXDVIGBM=ipag.ttf; ANS2=ipa-ttf
	fi
	    ;;
	[Jj])
	    if [ $ipaofnt = 0 ]; then ANS2=N; else
		updmap-sys --nomkmap --enable KanjiMap ptex-ipa-otf.map &>/dev/null
		PXDVIRML=ipam.otf; PXDVIGBM=ipag.otf; ANS2=ipa-otf
	    fi
	    ;;
	[Nn]) ;;
	*) echo ANS2=N;;
    esac
    case $ANS2 in
	[Nn])
	    updmap-sys --nomkmap --enable KanjiMap ptex-noEmbed.map &>/dev/null
	    ANS2=noEmbed;;
    esac
else
    ANS2=noEmbed
    updmap-sys --nomkmap --enable KanjiMap ptex-noEmbed.map &>/dev/null
fi



## pxdvi
setrmlgbm() {
    if test -n "$2"; then
        echo "set '$2' as $1."
        sedwrite $TEXMF/xdvi/pxdvi.cfg "s/^replace\s$1\s.*/replace $1 $2/"
    else
        echo "$0: No font was found as $1."
        exit 1
    fi
}

rmlgbm() {
    if  $SRCDIR/inst/bin/$ARCH/pxdvi \
	--version | grep Fontconfig > /dev/null; then
        echo "  Fontconfig enabled."
        echo "    'fc-match Ryumin'     = " `fc-match Ryumin`
        echo "    'fc-match GothicBBB'  = " `fc-match GothicBBB`
        echo "    'fc-match serif'      = " `fc-match serif`
        echo "    'fc-match sans-serif' = " `fc-match sans-serif`
        if test "`fc-match Ryumin`" != "`fc-match GothicBBB`"; then
            echo "  Using fontconfig setting (Ryumin & GothicBBB)."
	    sedwrite $TEXMF/xdvi/pxdvi.cfg \
		"s/^(replace\sRyumin.*)/%\1/;s/^(replace\sGothic.*)/%\1/"
	    PXDVIRML=Ryumin; PXDVIGBM=GothicBBB
	    return
	elif test "`fc-match serif`" != "`fc-match sans-serif`"; then
            echo "  Using fontconfig setting (serif & sans-serif)."
	    PXDVIRML=serif; PXDVIGBM=sans-serif
            return
        else
            echo "  Ignoring fontconfig setting."
            echo ""
        fi
    else
        echo "  Fontconfig disabled."
    fi
   while read FONT; do
        case $FONT in
            \#*) continue;;
        esac
        case $MINGOTH in
            PXDVIRML) MINGOTH=PXDVIGBM;;
            *)        MINGOTH=PXDVIRML;;
        esac
        g=0
        kpsewhich -format 'truetype fonts' $FONT > /dev/null && g=1
        kpsewhich -format 'opentype fonts' $FONT > /dev/null && g=1
        if test $g != 0; then
            echo "  '$FONT' was found as '$MINGOTH'"
            eval $MINGOTH=$FONT
        fi
    done
}

if [ -z "$PXDVIRML" ] ; then
    echo ; echo -e "\e[1;36mSetting fonts for pxdvi...\e[0m"
    rmlgbm <<EOF
# in case of no mincho font (mainly for Mandriva)
        umeplus-gothic.ttf
        dummy
        VL-Gothic-Regular.ttf
        dummy
# kochi (distribution stopped)
        kochi-mincho.ttf
        kochi-gothic.ttf
# kochi-subst (former of sazanami)
        kochi-mincho-subst.ttf
        kochi-gothic-subst.ttf
# sazanami http://wiki.fdiary.net/font/?sazanami
#        sazanami-mincho.ttf
#        sazanami-gothic.ttf
# UmePlus gothic font family (Mandriva Cooker 20080104)
# http://www.geocities.jp/ep3797/modified_fonts_01.html
        dummy
        umeplus-gothic.ttf
# VL gothic font family http://dicey.org/vlgothic/
        dummy
        VL-Gothic-Regular.ttf
# IPA mona http://www.geocities.jp/ipa_mona/
# (opfc-ModuleHP-1.1.1_withIPAMonaFonts-1.0.5.tar.gz)
        ipam-mona.ttf
        ipag-mona.ttf
# IPA font http://ossipedia.ipa.go.jp/ipafont/
        ipam.ttf
        ipag.ttf
        ipam.otf
        ipag.otf
# DynaLab
        dfmimp3.ttc
        dfgotp5.ttc
# Windows native
        msmincho.ttc
        msgothic.ttc
# Ricoh TTF
        lxmincho.ttc
        lxgothic.ttc
# Turbo Linux 10
        tlmincho.ttc
        tlgothic.ttc
# Solaris 9
        HG-MinchoL.ttf
        HG-GothicB.ttf
# Solaris 10
        hgmlsun.ttf
        hggbsun.ttf
# Kozuka
        KozMinStd-Regular.otf
        KozGoStd-Regular.otf
        KozMinPro-Regular.otf
        KozGoPro-Medium.otf
        KozMinProVI-Regular.otf
        KozGoProVI-Medium.otf
        KozMinPr6N-Regular.otf
        KozGoPr6N-Medium.otf
# Hiragino
        HiraMinPro-W3.otf
        HiraKakuPro-W3.otf
        HiraMinProN-W3.otf
        HiraKakuProN-W3.otf
EOF
fi

if [ -z $PXDVIRML -o -z $PXDVIGBM ]; then
    echo ; echo -e "\e[1;31mI couldn't find fonts for pxdvi.\e[0m"

#    echo -n "Download IPA font? (y/n) > "
#    read ANS
    ANS=N
    case $ANS in
	[Yy]|[Yy][Ee][Ss])
	    if [ ! -f $TLSRCDIR/IPAfont00302.zip ]; then
		cd $TLSRCDIR
		echo -e "\e[0;33m[downloading]\e[0m IPAfont00302.zip"
		wget http://info.openlab.ipa.go.jp/ipafont/fontdata/IPAfont00302.zip &>/dev/null
	    else
		echo "IPAfont00302.zip is already downloaded."
	    fi
	    cd $TEXMF
	    echo -e "\e[0;33m[extracting]\e[0m  IPAfont00302.zip"
	    unzip $TLSRCDIR/IPAfont00302.zip
	    mkdir -p doc/fonts/ipafont
	    mv IPAfont00302/*.txt doc/fonts/ipafont/
	    mkdir -p fonts/truetype/ipafont
	    mv IPAfont00302/ipa?.ttf  fonts/truetype/ipafont/
	    rm -rf IPAfont00302*
	    echo; echo -e "\e[1;31mrestarting font.sh...\e[0m"; echo
	    cd $TLSRCDIR && scripts/font.sh
	    ;;
	*) 
	    echo -e "\e[1;31mPlease edit pxdvi.cfg manually.\e[0m"
	    ;;
    esac
else
    echo 
    setrmlgbm Ryumin-Light     $PXDVIRML
    setrmlgbm GothicBBB-Medium $PXDVIGBM
fi


echo "Finishing..."
mktexlsr &>/dev/null
updmap-sys &>/dev/null
fmtutil-sys --all &>/dev/null
exit 0
