#!/bin/bash
# Build Step 1 - extracting / patching source file and build

. ./option
export CFLAGS
unset CXXFLAGS
unset LDFLAGS

cd $CMP_TEMP
echo "[clean ]"
rm -rf texlive-*-source uptex-*
echo "[unpack] texlive-*-source.tar"
tar xf $SRC/texlive-*-source.tar
pushd $SRC
UPTEX_VER=`ls  uptex-*.tar.gz|sed "s/uptex-/u/;s/.tar.gz//"`
EPTEX_VER=`ls  eptex-*.tar.bz2|sed "s/eptex-//;s/.tar.bz2//"`
popd
echo "[unpack] uptex-*.tar.gz"
tar zxf $SRC/uptex-*.tar.gz 
cd texlive-*-source/texk
echo "[unpack] makejvf-1.1a.tar.gz"
tar zxf $SRC/makejvf-1.1a.tar.gz
echo "[unpack] mendexk2.6e.tar.gz"
echo "[unpack] ptexenc-0.999.tar.gz"
tar zxf $SRC/mendexk2.6e.tar.gz
tar zxf $SRC/ptexenc-0.999.tar.gz
cd web2c
echo "[unpack] ptex-src-3.1.10.tar.gz"
tar zxf $SRC/ptex-src-3.1.10.tar.gz
echo "[unpack] eptex-*.tar.gz"
tar jxf $SRC/eptex-*.tar.bz2
mv ptex-src-3.1.10/ ptexdir
cd ..
mv makejvf-1.1a/ makejvf
mv mendexk2.6e/ mendexk
mv ptexenc-0.999/ ptexenc
echo "[patch ] ptexlive's patch"
bash ptexenc/patches/texlive2008.sh &>/dev/null
patch -p1 -d mendexk < ptexenc/patches/mendexk2.6e-ptexenc.patch  &>/dev/null
patch -p1 -d makejvf < ptexenc/patches/makejvf-1.1a-ptexenc.patch &>/dev/null
cat web2c/ptexdir/ptexextra.in \
  | sed s/3.141592/3.1415926/ > web2c/ptexdir/ptexextra.in2
mv web2c/ptexdir/ptexextra.in2 web2c/ptexdir/ptexextra.in
cd ..
echo "[copy  ] ptexdir -> eptexdir"
cp -r texk/web2c/ptexdir texk/web2c/eptexdir
cp  texk/web2c/eptex-*/* texk/web2c/eptexdir/ 
echo "[patch ] ep-tl08.patch"
patch -p1 < $SRC/ep-tl08.patch 
cd texk/dvipsk
echo "[unpack] dvipsk-5.97-p1.7b-tl.tar.gz"
tar zxf $SRC/dvipsk-5.97-p1.7b-tl.tar.gz 
echo "[patch ] dvipsk-5.97-p1.7b-tl.diff"
patch -p1 < dvipsk-5.97-p1.7b-tl.diff &>/dev/null
cd ../xdvik
echo "[patch ] xdvik-tl08.patch.gz"
zcat $SRC/xdvik-tl08.patch.gz | patch -p1 &>/dev/null
autoconf
cd ../web2c/
echo "[copy  ] ptexdir -> uptexdir"
cp -r ptexdir/ uptexdir
cd uptexdir
mv ptex-base.ch uptex-base.ch
mv ptftopl.ch uptftopl.ch
mv ppltotf.ch uppltotf.ch
mv pdvitype.ch updvitype.ch
mv jbibtex.ch  upjbibtex.ch
cd ../../../
echo "[copy  ] upovp2ovf"
cp texk/web2c/omegaware/ovp2ovf.web texk/web2c/omegaware/upovp2ovf.web 
cp texk/web2c/omegaware/ovp2ovf.ch texk/web2c/omegaware/upovp2ovf.ch 
echo "[patch ] uptex_src-*.patch"
cat $CMP_TEMP/uptex-*/patch/ptetex3-*_uptex_src-*.patch \
  |sed "s/3.141592/3.1415926/" > $CMP_TEMP/uptex-base-tmp.patch
patch -p2 -f < $CMP_TEMP/uptex-base-tmp.patch &>/dev/null
cd texk/web2c/
echo "[copy  ] uptexdir -> euptexdir"
cp -r uptexdir/ euptexdir
cd euptexdir/      
cat ../eptexdir/etex.diff | sed "s/, Version 3.141592/, Version 3.1415926/" > etex.diff
cd ../../..
echo "[patch ] up-tl08.patch"
cat $SRC/up-tl08.patch |sed "s/UPTEXVER/$UPTEX_VER/;s/EPTEXVER/$EPTEX_VER/" > $CMP_TEMP/up-tl08.patch 
patch -p1 < $CMP_TEMP/up-tl08.patch 

cd $CMP_TEMP/texlive-*-source
./Build $CONF_OPT 



# The following block will not executed.
if test "$FAM256" = "1"; then
  echo "*** Make FAM256 enabled binaries of e-pTeX and e-upTeX ***"
  echo "         Return key to continue, or Ctrl+C to abort"
  read
  cd $CMP_TEMP/texlive-*-source/Work/texk/web2c

  sed s/PTEX-VERSION/`cat ptexdir/ptex.version`-`cat eptexdir/eptex.version` FAM256-PATCHED/ \
     ../../../texk/web2c/eptexdir/ptexextra.in >ptexextra.h

  cp eptex.web eptex.web.orig
  ./tie -m eptex.web eptex.web.orig ../../../texk/web2c/eptexdir/fam256.ch

  cp euptex.web euptex.web.orig
  cat <<EOF > fam256.diff
--- fam256.ch.orig      2009-02-17 22:04:09.833587170 +0900
+++ fam256.ch   2009-02-17 22:06:07.325599785 +0900
@@ -259,9 +259,9 @@
 @z
 %-----------------------------------------------
 @x
-char_given,math_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given: scanned_result(cur_chr)(int_val);
 @y
-char_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
 @z
 %-----------------------------------------------
 @x
EOF
  cp ../../../texk/web2c/eptexdir/fam256.ch fam256.ch
  patch -p0 < fam256.diff
  ./tie -m euptex.web euptex.web.orig fam256.ch

  cat ../../../texk/web2c/texmfmem.h|sed "s/#if\ \!defined(Omega)/#if\ \!defined(Omega)\ \&\&\ \!defined(epTeX)\ \&\&\ \!defined(eupTeX)/" > ../../../texk/web2c/texmfmem2.h
  cat ../../../texk/web2c/texmfmem.h|sed "s/#if\ \!defined(Omega)/#if\ \!defined(Omega)\ \&\&\ \!defined(epTeX)\ \&\&\ \!defined(eupTeX)/" > ../../../texk/web2c/texmfmem3.h
  mv ../../../texk/web2c/texmfmem.h ../../../texk/web2c/texmfmem.h.orig
  mv ../../../texk/web2c/texmfmem2.h ../../../texk/web2c/texmfmem.h
  cat <<EOF >> ../../../texk/web2c/eptexdir/kanji.h
  #define getintone(w) ((w).cint1)
  #define setintone(w,a) ((w).cint1=(a))
EOF
cat <<EOF >> ../../../texk/web2c/eptexdir/eptex.defines
  @define function getintone();
  @define procedure setintone();
EOF
  cat <<EOF >> ../../../texk/web2c/euptexdir/kanji.h
  #define getintone(w) (w).cint1
  #define setintone(w,a) ((w).cint1=(a))
EOF
cat <<EOF >> ../../../texk/web2c/euptexdir/euptex.defines
  @define function getintone();
  @define procedure setintone();
EOF

  rm eptex.p eptex.pool eptexextra.o eptexdir/kanji.o
  rm eptexdir/printversion.o eptexdir/usage.o eptexdir/openclose.o eptexdir/plib.a 
  make eptex || exit 0

  rm euptex.p euptex.pool euptexextra.o euptexdir/kanji.o
  rm euptexdir/printversion.o euptexdir/usage.o euptexdir/openclose.o euptexdir/plib.a 
  make euptex

  ARCH=`ls $CMP_TEMP/texlive-20080816-source/inst/bin`
  cp eptex ../../../inst/bin/$ARCH/
  cp euptex ../../../inst/bin/$ARCH/
  cp eptex.pool ../../../inst/texmf/web2c/
  cp euptex.pool ../../../inst/texmf/web2c/
fi
