% This is change file of floating-point arithmetic in e-pTeX.
% By Hironori Kitagawa (h_kitagawa2001 at yahoo.co.jp)

@x
@d eTeX_states=1 {number of \eTeX\ state variables in |eqtb|}
@y
@d eTeX_states=2 {number of \eTeX\ state variables in |eqtb|}
@d fpout_code=1 {How many significant digits of float will be printd? }
@z


@x 
   if (history <> spotless) and (history <> warning_issued) then
       uexit(1)
   else
       uexit(0);
   end
@y
   if (history <> spotless) and (history <> warning_issued) then
       uexit(1)
   else
       uexit(0);
   fpdest;
   end
@z

@x
@d advance=max_internal+1 {advance a register or parameter ( \.{\\advance} )}
@y
@d float_arith=max_internal+1 {floating point operation (\.{\\fpadd} etc.~)}
@d advance=float_arith+1 {advance a register or parameter ( \.{\\advance} )}
@z

@x
@d etex_convert_codes=etex_convert_base+1 {end of \eTeX's command codes}
@y
@d fp_out_frac_code=etex_convert_base+1 {command code for \.{\\fpfrac}}
@d fp_out_expr_code=etex_convert_base+2 {command code for \.{\\fpexpr}}
@d etex_convert_codes=etex_convert_base+3 {end of \eTeX's command codes}
@z

@x
  eTeX_revision_code: print_esc("eTeXrevision");
  othercases print_esc("jobname")
@y
  eTeX_revision_code: print_esc("eTeXrevision");
  fp_out_frac_code: print_esc("fpfrac");
  fp_out_expr_code: print_esc("fpexpr");
  othercases print_esc("jobname")
@z

@x
font_name_code: scan_font_ident;
eTeX_revision_code: do_nothing;
@y
font_name_code: scan_font_ident;
fp_out_frac_code,fp_out_expr_code: begin cur_val:=0; scan_float; end;
eTeX_revision_code: do_nothing;
@z

@x
eTeX_revision_code: print(eTeX_revision);
job_name_code: print(job_name);
@y
eTeX_revision_code: print(eTeX_revision);
fp_out_frac_code: do_fp_out_frac; 
fp_out_expr_code: do_fp_out_expr; 
job_name_code: print(job_name);
@z

@x
eTeX_expr-int_val+mu_val: print_esc("muexpr");
@y
eTeX_expr-int_val+mu_val: print_esc("muexpr");
@<FL Cases of |last_item| for |print_cmd_chr|@>
@z

@x
@<Process an expression and |return|@>=
begin if m<eTeX_mu then
  begin case m of
@y 
@<Process an expression and |return|@>=
begin 
if m>eTeX_expr-int_val+mu_val then 
  @<FL process floating point arithmetical commands@>
else 
 begin if m<eTeX_mu then
   begin case m of
@z
@x
  else negate(cur_val);
@y
    else negate(cur_val);
end;
@z

@x
@* \[55] Index.
@y
@* \[60] Floating point arithmetic.
\epTeX\ supports floating-point arithmetic.

This version of \epTeX\ uses MPFR library for internal calculation
routine. \.{eptex-fp.c} is bridge between this \WEB\ source and MPFR library.
A float is ``packed'' in a glue specification. Please see \.{eptex-fp.c}.

@ In this implementation of \epTeX, \.{\\fpinit} and \.{\\fpdest} are
not needed anymore.

@<Initialize whatever...@>= 
fpinit;

@ @d fpout_state==eTeX_state(fpout_code)

@<Cases for |print_param|@>=
eTeX_state_code+fpout_code:print_esc("fpoutprec");

@ We define {\it all} commands related to floating point operation here.

@<Generate all \eTeX...@>=
primitive("fpoutprec",assign_int,eTeX_state_base+fpout_code);
@!@:fp_out_prec_}{\.{\\fpoutprec} primitive@>
primitive("real",last_item,eTeX_expr-int_val+mu_val+3);@/@!@:real_}{\.{\\real} primitive@>
@#
primitive("fpadd",float_arith,1);@!@:fpadd_}{\.{\\fpadd} primitive@>
primitive("fpsub",float_arith,2);@!@:fpsub_}{\.{\\fpsub} primitive@>@/
primitive("fpmul",float_arith,3);@!@:fpmul_}{\.{\\fpmul} primitive@>
primitive("fpdiv",float_arith,4);@!@:fpdiv_}{\.{\\fpdiv} primitive@>@/
primitive("fppow",float_arith,5);@!@:fppow_}{\.{\\fppow} primitive@>
@#
primitive("fpneg",float_arith,101);@!@:fpneg_}{\.{\\fpneg} primitive@>
primitive("fpsqr",float_arith,102);@!@:fpsqr_}{\.{\\fpsqr} primitive@>
primitive("fpexp",float_arith,103);@!@:fpexp_}{\.{\\fpexp} primitive@>
primitive("fpabs",float_arith,104);@!@:fpabs_}{\.{\\fpabs} primitive@>
primitive("fpceil",float_arith,105);@!@:fpceil_}{\.{\\fpceil} primitive@>
primitive("fpfloor",float_arith,106);@!@:fpfloor_}{\.{\\fpfloor} primitive@>
primitive("fpsin",float_arith,107);@!@:fpsin_}{\.{\\fpsin} primitive@>
primitive("fpcos",float_arith,108);@!@:fpcos_}{\.{\\fpcos} primitive@>
primitive("fptan",float_arith,109);@!@:fptan_}{\.{\\fptan} primitive@>
primitive("fpsinh",float_arith,110);@!@:fpsinh_}{\.{\\fpsinh} primitive@>
primitive("fpcosh",float_arith,111);@!@:fpcosh_}{\.{\\fpcosh} primitive@>
primitive("fptanh",float_arith,112);@!@:fptanh_}{\.{\\fptanh} primitive@>
@#
primitive("fplog",float_arith,113);@!@:fplog_}{\.{\\fplog} primitive@>
primitive("fpasinh",float_arith,114);@!@:fpasinh_}{\.{\\fpasinh} primitive@>
primitive("fpacosh",float_arith,115);@!@:fpacosh_}{\.{\\fpacosh} primitive@>
primitive("fpatanh",float_arith,116);@!@:fpatanh_}{\.{\\fpatanh} primitive@>
primitive("fpasin",float_arith,117);@!@:fpasin_}{\.{\\fpasin} primitive@>
primitive("fpacos",float_arith,118);@!@:fpacos_}{\.{\\fpacos} primitive@>
primitive("fpatan",float_arith,119);@!@:fpatan_}{\.{\\fpatan} primitive@>
@#
primitive("fpfrac",convert,fp_out_frac_code);
@!@:fpfrac_}{\.{\\fpfrac} primitive@>
primitive("fpexpr",convert,fp_out_expr_code);
@!@:fpexpr_}{\.{\\fpexpr} primitive@>@/
primitive("fptoint",last_item,eTeX_expr-int_val+mu_val+6);
@!@:fp_to_inte_}{\.{\\fptoint} primitive@>
primitive("fptodim",last_item,eTeX_expr-int_val+mu_val+7);
@!@:fp_to_dim_}{\.{\\fptodim} primitive@>

@ @<FL process floating point arithmetical commands@>=
begin case m-(eTeX_expr-int_val+mu_val) of
  3: @<FL scan float and pack it into glue specification@>;@/
  6: do_fp_convert_to_int;@/
  7: do_fp_convert_to_dim;@/
  end;@+end

@ @<Assignments@>=
float_arith: do_float_operation(a,cur_chr);

@ @<Cases of |main_control| that don't...@>=
any_mode(float_arith):prefixed_command;

@ @<FL Cases of |last_item| for |print_cmd_chr|@>=
eTeX_expr-int_val+mu_val+3: print_esc("real");
eTeX_expr-int_val+mu_val+6: print_esc("fptoint");
eTeX_expr-int_val+mu_val+7: print_esc("fptodim");

@ @<Cases of |print_cmd_chr|...@>=
float_arith: case chr_code of
1: print_esc("fpadd");@+
2: print_esc("fpsub");
3: print_esc("fpmul");@+
4: print_esc("fpdiv");
5: print_esc("fppow");@+
101: print_esc("fpneg");@+
102: print_esc("fpsqr");@+
103: print_esc("fpexp");
104: print_esc("fpabs");@+
105: print_esc("fpceil");@+
106: print_esc("fpfloor");
107: print_esc("fpsin");@+
108: print_esc("fpcos");@+
109: print_esc("fptan");
110: print_esc("fpsinh");@+
111: print_esc("fpcosh");@+
112: print_esc("fptanh");
113: print_esc("fplog");@+
114: print_esc("fpasinh");@+
115: print_esc("fpacosh");
116: print_esc("fpatanh");@+
117: print_esc("fpasin");@+
118: print_esc("fpacos");
119: print_esc("fpatan");
end;

@ Our first goal is \.{\\real} command, which reads representation of
a float and pack it into a glue. You can use this command like
\.{\\real 1.3e2}; and for example, \.{\\real \\skip 32} is treated as
\.{\\skip 32}.

@ To express exponental part in \TeX\
source, One can write like {\tt 1.23e12}. Uppercase `E' is of course
permitted. 

@d exponent_e_token=letter_token+"e" {lowercase `e'} 
@d exponent_E_token=letter_token+"E" {uppercase `E'} 
@d other_exponent_e_token=other_token+"e" {lowercase `e' of type |other_token|} 
@d other_exponent_E_token=other_token+"E" {uppercase `E' of type |other_token|}

@ Here we define |scan_float| procedure, which reads a float and store it to |fbuf[$w$]|.

@p
procedure scan_float; 
label done1;
var
@!n,@!m,@!d,@!w: integer; {counter}
@!already_point: boolean; {already found the decimal point?}
@!negative: boolean; {should the answer be negated?}
@!OK_so_far:boolean; {has an error message been issued?}
@!q: pointer; {new glue specification}
begin OK_so_far:=true; w:=cur_val;
@<Get the next non-blank non-sign token...@>;
if (cur_cmd>=min_internal)and(cur_cmd<=max_internal) then begin
  scan_something_internal(glue_val,negative);
  if cur_val_level=glue_val then begin
    decr(glue_ref_count(cur_val)); { decrease reference count }
    fpi_unpack(w,cur_val);
    end
  else begin
    if cur_val_level=dimen_val then d:=-16 else d:=0;
    fpi_int_to_float(w,cur_val,d);
    end;
  end
else begin
  @<FL scan fraction part@>;@/
  @<FL scan exponent part@>;@/
  fpi_exp_ten(w,m);if negative then fpi_neg(w);
@+ end; 
end;

@ @<FL scan fraction part@>=
 already_point:=false; fpi_zero(w);  m:=0;
 loop@+ begin
 if (cur_tok>=zero_token)and (cur_tok<=zero_token+9) then
   begin 
     d:=cur_tok-zero_token;
     fpi_rshift_add(w,d);
     if already_point then m:=m+1;
    end
 else if (cur_tok=point_token)or(cur_tok=continental_point_token) then 
   already_point:=true
 else goto done1;
   get_x_token;
 end;
done1:

@ @<FL scan exponent part@>=
if cur_tok=exponent_E_token then cur_tok:=exponent_e_token
else if cur_tok=other_exponent_E_token then cur_tok:=exponent_e_token
else if cur_tok=other_exponent_e_token then cur_tok:=exponent_e_token;
if cur_tok=exponent_e_token then begin
  scan_int; m:=cur_val-m;
  end
else begin
  if cur_cmd<>spacer then back_input;
  m:=-m;
  end;
@<Scan an optional space@>;

@ @<FL scan float and pack it into glue specification@>=
begin cur_val:=0; scan_float; cur_val:=fpi_pack(0); cur_val_level:=glue_val; 
  end

@ Next, we deal with operation of floats.

@<Declare subprocedures for |prefixed_command|@>=
procedure do_float_operation(@!a:small_number;@!f:halfword);
label found,exit;
var @!l,@!q,@!r,@!s,@!t,@!gh:pointer; {for list manipulation}
@!e:boolean; {does |l| refer to a sparse array element?}
begin 
@<FL scan first argument, in |do_float_operation|@>;@/
if f<100 then @<FL cases for binary operation, in |do_float_operation|@>@/
else fpi_unary_operation(f,0,2);
cur_val:=fpi_pack(2); sa_define(l,cur_val)(l,glue_ref,cur_val);
exit: end;

@ @<FL scan first argument, in |do_float_operation|@>=
e:=false; {just in case, will be set |true| for sparse array elements}
get_x_token;
if cur_cmd=assign_glue then begin l:=cur_chr; goto found; end;
if cur_cmd<>register then begin
  print_err("You can't use `"); print_cmd_chr(cur_cmd,cur_chr);
@.You can't use x after ...@>
  print("' after "); print_cmd_chr(q,0);
  help1("I'm forgetting what you said and not changing anything.");
  error; return; end;
if (cur_chr<mem_bot)or(cur_chr>lo_mem_stat_max) then
  begin l:=cur_chr; e:=true; end
else  begin scan_register_num;
  if cur_val>255 then
    begin find_sa_element(glue_val,cur_val,true); l:=cur_ptr; e:=true;
    end
  else l:=cur_val+skip_base;
end;
found: if e then s:=sa_ptr(l)@+else s:=equiv(l);
fpi_unpack(0,s);

@ @<FL cases for binary operation, in |do_float_operation|@>=
begin 
  if scan_keyword("by") then do_nothing; {optional `\.{by}'}
  cur_val:=1; scan_float; fpi_binary_operation(f,0,1,2);
  end



@ Next two procedures outputs the fraction part and the exponent part
of flost, respectively. 

@p procedure do_fp_out_frac;
label exit;
var @!i,@!j,@!k: integer;
begin
  if is_float_nan(0) then print("NaN")
  else begin
    fpi_out_frac_init(0,fpout_state); i:=0; j:=0;
    k:=fpi_out_frac_read(0);
    if k=10 then begin print("-"); k:=1; end
    else k:=0;
    j:=fpi_out_frac_read(i+k);
    while j<>11 do begin
      print(j); i:=i+1; j:=fpi_out_frac_read(i+k);
      if i=1 then print (".");
      end;
  end;
end;
@#
procedure do_fp_out_expr;
begin
  print_int(fpi_out_expr(0,fpout_state));
end;


@ The conditional \.{\\iffp} primitive tests relations between two floats.

@d if_fp_code=25 { `\.{\\iffp}' }

@<Generate all \eTeX...@>=
primitive("iffp",if_test,if_fp_code);@/
@!@:if_fp_}{\.{\\iffp} primitive@>

@ @<Cases of |if_test| for |print_cmd_chr|@>=
if_fp_code:print_esc("iffp");

@ @<Cases for |conditional|@>=
if_fp_code: begin cur_val:=0; scan_float;
@<Get the next non-blank non-call...@>;
if (cur_tok>=other_token+"<")and(cur_tok<=other_token+">") then@/
  r:=cur_tok-other_token
else  begin print_err("Missing = inserted for ");
@.Missing = inserted@>
  print_cmd_chr(if_test,this_if);@/
  help1("I was expecting to see `<', `=', or `>'. Didn't.");
  back_error; r:="=";@+ end;
  cur_val:=1; scan_float;
  if is_float_comparable(0,1) then begin
    p:=fpi_compare(0,1);
    case r of
      "<": b:=(p<0);@+
      "=": b:=(p=0);@+
      ">": b:=(p>0);
      end;@+
    end
  else b:=false;
end;

@ Last things we have to define are convert a float to an integer
or an dimension.  Of course, an float `1.0' is regard as an integer
`1', or a dimension `1.0$\,$pt'.  If absolute value of an float is too
large for an integer/a dimension, Over flow error is occured.  On the
other hand, If absolute value of an float is too small, the float is
converted to zero.

@p procedure do_fp_convert_to_int; {round down}
var @!p: pointer;
begin
  cur_val:=0; scan_float;
  if is_float_nan(0) then { NaN }
  begin  print_err("This float is not a number");@/
@.This float is not a number@>
    help2("This float is NaN (Not A Number),")@/
      ("so I changed `result' to zero.");
    error; cur_val:=0;
    end
  else if is_float_in_range(0) then{ overflow } begin 
    print_err("Number too big");@/
@.Number too big@>
    help2("I can only go up to 2147483647='17777777777=""7FFFFFFF,")@/
      ("so I'm using that number instead of yours.");
    error; cur_val:=infinity; 
    if fpi_float_sign(0)<0 then cur_val:=-cur_val;
    end
  else cur_val:=fpi_float_to_int(0);
  cur_val_level:=int_val; 
end;


@ Procedure |do_fp_convert_to_dim| is similar to above code. 

@p procedure do_fp_convert_to_dim; {round down}
var @!p: pointer;
begin
  cur_val:=0; scan_float; fpi_mul_two_beki(0,16);
  if is_float_nan(0) then { NaN }
  begin  print_err("This float is not a number");@/
@.This float is not a number@>
    help2("This float is NaN (Not A Number),")@/
      ("so I changed `result' to zero.");
    error; cur_val:=0;
    end
  else if is_float_in_range(0) then{ overflow } begin 
    @<Report that this dimension is out of range@>;
    if fpi_float_sign(0)<0 then cur_val:=-cur_val;
    end
  else cur_val:=fpi_float_to_int(0);
  cur_val_level:=dimen_val; 
end;

@* \[61] Index.
@z
