/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


package jp.ac.naka.ec.serial;

/**
 * MOXÃZT[foCX\NX
 * @author J
 * 
 */
public class MoxaDeviceType {
	public static final int DEVICE_TYPE_NULL = 0; // !< foCXڑĂȂƂw肵Ă
	public static final int SENSOR_TYPE_COLOR = 1; // !< ZT[
	public static final int SENSOR_TYPE_INFRARED = 2; // !< ԊOZT[
	public static final int SENSOR_TYPE_SGAS = 3; // !< KXZT[ (o)
	public static final int SENSOR_TYPE_HUMIDITY = 4; // !< xZT[
	public static final int SENSOR_TYPE_TEMPERATURE = 5; // !< xZT[
	public static final int SENSOR_TYPE_MIC = 6; // !< }CN
	public static final int SENSOR_TYPE_AIRPRESSURE = 7; // !< CZT[
	public static final int SENSOR_TYPE_PRESSURE = 8; // !< ̓ZT[
	public static final int SENSOR_TYPE_ACCE = 9; // !< xZT[
	public static final int SENSOR_TYPE_GYRO = 10; // !< pxZT[
	public static final int SENSOR_TYPE_BEND = 11; // !< ȂZT[
	public static final int SENSOR_TYPE_TOUCH = 12; // !< ^b`ZT[
	public static final int SENSOR_TYPE_PUSH = 13; // !< vbV{^
	public static final int SENSOR_TYPE_SLIDER = 14; // !< XC_[
	public static final int SENSOR_TYPE_ROTATION = 15; // !< [^[
	public static final int ACTUATOR_TYPE_LED = 16; // !< LED (Sink^Cv)
	public static final int ACTUATOR_TYPE_LED2 = 17; // !< LED (Source^Cv)
	public static final int DEVICE_TYPE_SIZEOF = 18;// !< foCX̎ނ\񋓌`̐
	
	public static String getSensorTypeString(int type) {
		String retval = "";
		switch (type) {
		case DEVICE_TYPE_NULL : retval = "DEVICE_TYPE_NULL"; break;
		case SENSOR_TYPE_COLOR : retval = "DEVICE_TYPE_COLOR"; break;
		case SENSOR_TYPE_INFRARED : retval = "SENSOR_TYPE_INFRARED"; break;
		case SENSOR_TYPE_SGAS : retval = "SENSOR_TYPE_SGAS"; break;
		case SENSOR_TYPE_HUMIDITY : retval = "SENSOR_TYPE_HUMIDITY"; break;
		case SENSOR_TYPE_TEMPERATURE : retval = "SENSOR_TYPE_TEMPERATURE"; break;
		case SENSOR_TYPE_MIC : retval = "SENSOR_TYPE_MIC"; break;
		case SENSOR_TYPE_AIRPRESSURE : retval = "SENSOR_TYPE_AIRPRESSURE"; break;
		case SENSOR_TYPE_PRESSURE : retval = "SENSOR_TYPE_PRESSURE"; break;
		case SENSOR_TYPE_ACCE : retval = "SENSOR_TYPE_ACCE"; break;
		case SENSOR_TYPE_GYRO : retval = "SENSOR_TYPE_GYRO"; break;
		case SENSOR_TYPE_TOUCH : retval = "SENSOR_TYPE_TOUCH"; break;
		case SENSOR_TYPE_PUSH : retval = "SENSOR_TYPE_PUSH"; break;
		case SENSOR_TYPE_SLIDER : retval = "SENSOR_TYPE_SLIDER"; break;
		case SENSOR_TYPE_ROTATION : retval = "SENSOR_TYPE_ROTATION"; break;
		case ACTUATOR_TYPE_LED : retval = "ACTUATOR_TYPE_LED"; break;
		case ACTUATOR_TYPE_LED2 : retval = "ACTUATOR_TYPE_LED2"; break;
		default :
			assert(false);
		}
		return retval;
	}
}
