/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.media;

import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;

/**
 * fBAZbV̊i[ɗpNXB
 * @author Takashi Kasuya
 *
 */
class SessionInformation {
	String addr;
	int port;
	int ttl = 1;
	Format format;
	DataSource ds;
	CaptureDeviceInfo device;
	Format capture_format;
	
	public SessionInformation(String addr, int port) {
		this.addr = addr;
		this.port = port;
	}

	public SessionInformation(String addr, int port, int ttl) {
		this(addr, port);
		this.ttl = ttl;
	}
	
	public String getMediaType () {
		return (format instanceof VideoFormat) ? "video" : "audio";
	}
}