/**
 * 
 */
package jp.ac.naka.ec.entity;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import jp.ac.naka.ec.db.DataObject;
import jp.ac.naka.ec.db.DataObjectImpl;
import jp.ac.naka.ec.db.DatabaseConnector;
import jp.ac.naka.ec.entity.EntityEvent.EventType;

/**
 * @author kasuya
 * 
 */
public class TupleSpaceAdapter implements EventDispatcher {

	private EventDispatcher dispatcher;

	private static TupleSpaceAdapter tuple = new TupleSpaceAdapter();

	private DatabaseConnector con;

	private Map<String, EventData> map = new HashMap<String, EventData>();

	private TupleSpaceAdapter() {
		dispatcher = EntityEventDispatcher.getInstance();
	}

	public void addEntityListener(EntityListener listener) {
		dispatcher.addEntityListener(listener);
	}

	public void dispatchEvent(EntityEvent evt) {
		if (con != null && evt.getSource() instanceof Entity
				&& evt.getEventType() == EventType.MESSAGE) {
			storeData(evt);
		}
		if (evt.getMessage() != null && evt.getSource() instanceof Entity
				&& evt.getEventType() == EventType.MESSAGE) {
			Entity source = (Entity) evt.getSource();
			String key = source.getURI().toString();
			EventData temp = new EventData();
			temp.name = source.getName();
			temp.value = evt.getMessage();
			if (evt.getMessage().equals("")) {
				// store sdp
				temp.value = evt.getSessionDescription().toString();
			}
			SimpleDateFormat formatter = new SimpleDateFormat(
					"yyyy.MM.dd 'at' hh:mm:ss");
			Date currentTime_1 = new Date();
			String dateString = formatter.format(currentTime_1);
			temp.date = dateString;
			if (source.getLocation() != null)
				temp.location = source.getLocation();
			map.put(key, temp);
		}
		dispatcher.dispatchEvent(evt);
	}

	/**
	 * ŐVf[^̂ݔzM
	 * 
	 * @param uri
	 * @return
	 */
	public String getDataByXML(String uri) {
		String ret = "";
		StringBuilder builder = new StringBuilder();
		if (uri == null) {
			// Retrieve all current data
			Set<String> set = map.keySet();

			for (String key : set) {
				EventData data = map.get(key);
				builder.append("<data uri=\"" + key + "\">");
				builder.append("<values>");
				String value;
				if (data.location != null)
					value = "<value name=\"" + data.name + "\" time=\""
							+ data.date + "\" location=\""
							+ data.location.getName() + "\" latitude=\""
							+ data.location.getLatitude() + "\" longitude=\""
							+ data.location.getLongitude() + "\">" + data.value
							+ "</value>";
				else
					value = "<value name=\"" + data.name + "\" time=\""
							+ data.date + "\">" + data.value + "</value>";
				builder.append(value);
				builder.append("</values>");
				
				builder.append("</data>");
			}

		} else {
			EventData data = map.get(uri);
			if (data != null) {
				builder.append("<data uri=\"" + uri + ">");
				builder.append("<values>");
				String value;
				if (data.location != null)
					value = "<value name=\"" + data.name + "\" time=\""
							+ data.date + "\" location=\""
							+ data.location.getName() + "\" latitude=\""
							+ data.location.getLatitude() + "\" longitude=\""
							+ data.location.getLongitude() + "\">" + data.value
							+ "</value>";
				else
					value = "<value name=\"" + data.name + "\" time=\""
							+ data.date + "\">" + data.value + "</value>";
				builder.append(value);
				builder.append("</values>");
				
				builder.append("</data>");
			}
		}
		ret = builder.toString();
		return ret;
	}

	public String getDataByXML(String uri, int num) throws SQLException {
		String ret = "";
		if (uri == null) {
			// TODO
		} else {
			StringBuilder builder = new StringBuilder();
			EventData[] data = con.getData(uri, num);
			builder.append("<data uri=\"" + uri + "\">");

			int count = 0;
			if (data.length != 0) {
				// ł͑SĈꏏɋAĂ
				/*
				 * if (data[0].location != null) { builder.append("<location
				 * name=\"" + data[0].location.getName() + "\">");
				 * builder.append(makeXML("latitude", data[0].location
				 * .getLatitude())); builder.append(makeXML("longitude",
				 * data[0].location .getLongitude())); builder.append("</location>"); }
				 */
				builder.append("<values>");
				for (EventData d : data) {
					if (d == null)
						break;
					String value = "";
					if (d.location != null)
						value = "<value seq=\"" + count++ + "\" name=\""
								+ d.name + "\" time=\"" + d.date
								+ "\" location=\"" + d.location.getName()
								+ "\" latitude=\"" + d.location.getLatitude()
								+ "\" longitude=\"" + d.location.getLongitude()
								+ "\">" + d.value + "</value>";
					else
						value = "<value seq=\"" + count++ + "\" name=\""
								+ d.name + "\" time=\"" + d.date + "\">"
								+ d.value + "</value>";
					builder.append(value);
				}
				builder.append("</values>");
			}
			builder.append("</data>");
			ret = builder.toString();
		}
		return ret;
	}

	public static TupleSpaceAdapter getInstance() {
		return tuple;
	}

	public void setDatabaseConnector(DatabaseConnector con) {
		this.con = con;
	}

	public void storeData(EntityEvent evt) {
		if (con == null) {
			return;
		}
		try {
			Entity source = (Entity) evt.getSource();
			EntityType type = source.getEntityType();
			Entity target = (Entity) evt.getTarget();
			String data = evt.getMessage();
			if (data != null) {
				DataObject obj = new DataObjectImpl(type, evt.getMessage(),
						source, target, source.getLocation());
				con.store(obj);
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	private String makeXML(String key, String data) {
		return "<" + key + ">" + data + "</" + key + ">";
	}
}
