/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity;

import javax.sip.address.SipURI;

import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.TreeNode;
import jp.ac.naka.ec.TreeNodeImpl;
import net.sourceforge.jsdp.SessionDescription;

/**
 * @author J
 * 
 */
public class EntityImpl extends TreeNodeImpl implements Entity {

	private EntityType type;

	private javax.sip.address.URI uri;
	private Location location;
	
	private boolean local = true;

	/**
	 * 
	 *
	 */
	public EntityImpl() {
		super();
		this.type = EntityType.SENSOR;
	}

	/**
	 * 
	 * @param parent
	 */
	public EntityImpl(Entity parent) {
		super(parent);
		this.type = EntityType.SENSOR;
	}

	/**
	 * 
	 * @param parent
	 * @param local
	 */
	public EntityImpl(Entity parent, boolean local) {
		super(parent);
		this.type = EntityType.SENSOR;
		this.local = local;
	}


	/**
	 * 
	 * @param name
	 */
	public EntityImpl(String name) {
		setName(name);
		this.type = EntityType.SENSOR;
	}
	
	/**
	 * 
	 * @param uri
	 */
	public EntityImpl(SipURI uri) {
		this();
		setName(uri.getUser());
		setURI(uri);
	}
	

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#getContainer()
	 */
	public EntityContainer getContainer() {
		TreeNode node = getParent();
		if (node instanceof EntityContainer) {
			return (EntityContainer) node;
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#getDescription()
	 */
	public String getDescription() {
		// TODO Auto-generated method stub
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#getEntityType()
	 */
	public EntityType getEntityType() {
		return this.type;
	}

	

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#getPriority()
	 */
	public float getPriority() {
		// TODO Auto-generated method stub
		return 0;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#getTupleId()
	 */
	public String getTupleId() {
		// TODO Auto-generated method stub
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#getURI()
	 */
	public javax.sip.address.URI getURI() {
		return this.uri;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#sendMessage(java.lang.String)
	 */
	public void sendMessage(String msg) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#sendMessage(java.lang.String, java.lang.String)
	 */
	public void sendMessage(String msg, String targetName){
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#sendMessage(java.lang.String, jp.ac.naka.ec.entity.EntityListener)
	 */
	public void sendMessage(String msg, EntityListener target){
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#sendOffer(net.sourceforge.jsdp.SessionDescription, jp.ac.naka.ec.entity.Entity)
	 */
	public boolean sendOffer(net.sourceforge.jsdp.SessionDescription sdp, Entity target) {
		// TODO Auto-generated method stub
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#sendOffer(jp.ac.naka.ec.entity.Entity)
	 */
	public boolean sendOffer(Entity target)  {
		// TODO Auto-generated method stub
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#setEntityType(jp.ac.naka.ec.entity.EntityType)
	 */
	public void setEntityType(EntityType type) {
		this.type = type;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#setPriority(float)
	 */
	public void setPriority(float priority) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#setTupleId(java.lang.String)
	 */
	public void setTupleId(String id) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#setURI(javax.sip.address.URI)
	 */
	public void setURI(javax.sip.address.URI uri) {
		this.uri = uri;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#receiveMessage(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void receiveMessage(EntityEvent e) {
	}

	
	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return getURI().toString();
	}


	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.Entity#isLocal()
	 */
	public boolean isLocal() {
		return local;
	}

	public void setLocal (boolean a) {
		this.local = a;
	}
	
	public void sendMessage(RequestMessage msg)  {}

	public void sendMessage(RequestMessage msg, EntityListener target){}


	public boolean sendBye(EntityListener target)  {
		return false;
	}
	
	@Override
	public boolean equals (Object obj) {
		if (getURI() == null) {
			return super.equals(obj);
		} else if (obj instanceof Entity) {
			Entity node = (Entity)obj;
			boolean a = node.getURI().toString().equals(getURI().toString());
			return a;
		}
		return false;
	}

	public Location getLocation() {
		return location;
	}

	public void setLocation(Location location) {
		this.location = location;
	}

	public void receiveBye(EntityEvent e) {}

	public SessionDescription receiveOffer(EntityEvent e) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#receiveAnswer(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void receiveAnswer(EntityEvent e) {}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#addedNewEntity(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void addedNewEntity(EntityEvent e) {}
}
