/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueArray
extends Value {
    private Value[] values;
    private int hash;

    public static ValueArray get(Value[] list) {
        return new ValueArray(list);
    }

    private ValueArray(Value[] list) {
        this.values = list;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = 1;
        int i = 0;
        while (i < this.values.length) {
            h = h * 31 + this.values[i++].hashCode();
        }
        this.hash = h;
        return this.hash;
    }

    public Value[] getList() {
        return this.values;
    }

    public int compareTo(ValueArray other, CompareMode mode) throws SQLException {
        for (int i = 0; i < this.values.length; ++i) {
            Value v1 = this.values[i];
            Value v2 = other.values[i];
            int comp = v1.compareTo(v2, mode);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public int getType() {
        return 17;
    }

    public long getPrecision() {
        return 0L;
    }

    public String getString() throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append('(');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.values[i].getString());
        }
        buff.append(')');
        return buff.toString();
    }

    protected int compareSecure(Value o, CompareMode mode) throws SQLException {
        ValueArray v = (ValueArray)o;
        if (this.values == v.values) {
            return 0;
        }
        if (this.values.length != v.values.length) {
            return this.values.length > v.values.length ? 1 : -1;
        }
        for (int i = 0; i < this.values.length; ++i) {
            Value v1 = this.values[i];
            Value v2 = v.values[i];
            int c = v1 == ValueNull.INSTANCE ? (v2 == ValueNull.INSTANCE ? 0 : -1) : (v2 == ValueNull.INSTANCE ? 1 : v1.compareSecure(v2, mode));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public Object getObject() throws SQLException {
        Object[] list = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            list[i] = this.values[i].getObject();
        }
        return list;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append('(');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.values[i].getSQL());
        }
        buff.append(')');
        return buff.toString();
    }

    public int getDisplaySize() {
        int size = 0;
        for (int i = 0; i < this.values.length; ++i) {
            size += this.values[i].getDisplaySize();
        }
        return size;
    }

    protected boolean isEqual(Value o) {
        if (!(o instanceof ValueArray)) {
            return false;
        }
        ValueArray v = (ValueArray)o;
        if (this.values == v.values) {
            return true;
        }
        if (this.values.length != v.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].isEqual(v.values[i])) continue;
            return false;
        }
        return true;
    }
}

