/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.doc;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.util.IOUtils;

public class LinkChecker {
    private static final boolean OPEN_EXTERNAL_LINKS = false;
    private HashMap targets = new HashMap();
    private HashMap links = new HashMap();

    public static void main(String[] args) throws Exception {
        new LinkChecker().run(args);
    }

    private void run(String[] args) throws Exception {
        String dir = "src/docsrc";
        for (int i = 0; i < args.length; ++i) {
            if (!"-dir".equals(args[i])) continue;
            dir = args[++i];
        }
        this.process(dir);
        this.listExternalLinks();
        this.listBadLinks();
    }

    void listExternalLinks() {
        Iterator it = this.links.keySet().iterator();
        while (it.hasNext()) {
            String link = (String)it.next();
            if (!link.startsWith("http") || link.indexOf("//localhost") > 0) continue;
            System.out.println("External Link: " + link);
        }
    }

    void listBadLinks() throws Exception {
        String link;
        ArrayList<String> errors = new ArrayList<String>();
        Iterator it = this.links.keySet().iterator();
        while (it.hasNext()) {
            link = (String)it.next();
            if (link.startsWith("http") || link.endsWith("h2.pdf") || this.targets.get(link) != null) continue;
            errors.add(this.links.get(link) + ": missing link " + link);
        }
        it = this.links.keySet().iterator();
        while (it.hasNext()) {
            link = (String)it.next();
            if (link.startsWith("http")) continue;
            this.targets.remove(link);
        }
        it = this.targets.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.targets.get(name).equals("name")) continue;
            errors.add("No link to " + name);
        }
        Collections.sort(errors);
        for (int i = 0; i < errors.size(); ++i) {
            System.out.println(errors.get(i));
        }
        if (errors.size() > 0) {
            throw new Exception("Problems where found by the Link Checker");
        }
    }

    void process(String path) throws Exception {
        if (path.endsWith("/CVS")) {
            return;
        }
        File file = new File(path);
        if (file.isDirectory()) {
            String[] list = file.list();
            for (int i = 0; i < list.length; ++i) {
                this.process(path + "/" + list[i]);
            }
        } else {
            this.processFile(path);
        }
    }

    void processFile(String path) throws Exception {
        this.targets.put(path, "file");
        String lower = path.toLowerCase();
        if (!lower.endsWith(".html") && !lower.endsWith(".htm")) {
            return;
        }
        String fileName = new File(path).getName();
        String parent = path.substring(0, path.lastIndexOf(47));
        String html = IOUtils.readStringAndClose(new FileReader(path), -1);
        int idx = -1;
        while ((idx = html.indexOf(" id=\"", idx + 1)) >= 0) {
            int start = idx + 4;
            int end = html.indexOf("\"", start + 1);
            if (end < 0) {
                this.error(fileName, "expected \" after id= " + html.substring(idx, idx + 100));
            }
            String ref = html.substring(start + 1, end);
            this.targets.put(path + "#" + ref, "id");
        }
        idx = -1;
        while ((idx = html.indexOf("<a ", idx + 1)) >= 0) {
            int end;
            int equals = html.indexOf("=", idx);
            if (equals < 0) {
                this.error(fileName, "expected = after <a at " + html.substring(idx, idx + 100));
            }
            String type = html.substring(idx + 2, equals).trim();
            int start = html.indexOf("\"", idx);
            if (start < 0) {
                this.error(fileName, "expected \" after <a at " + html.substring(idx, idx + 100));
            }
            if ((end = html.indexOf("\"", start + 1)) < 0) {
                this.error(fileName, "expected \" after <a at " + html.substring(idx, idx + 100));
            }
            String ref = html.substring(start + 1, end);
            if (type.equals("href")) {
                if (!ref.startsWith("http:") && !ref.startsWith("https:")) {
                    if (ref.startsWith("#")) {
                        ref = path + ref;
                    } else {
                        String p = parent;
                        while (ref.startsWith(".")) {
                            if (ref.startsWith("./")) {
                                ref = ref.substring(2);
                                continue;
                            }
                            if (!ref.startsWith("../")) continue;
                            ref = ref.substring(3);
                            p = p.substring(0, p.lastIndexOf(47));
                        }
                        ref = p + "/" + ref;
                    }
                }
                this.links.put(ref, path);
                continue;
            }
            if (type.equals("name")) {
                this.targets.put(path + "#" + ref, "name");
                continue;
            }
            this.error(fileName, "unsupported <a xxx: " + html.substring(idx, idx + 100));
        }
    }

    private void error(String fileName, String string) {
        System.out.println("ERROR with " + fileName + ": " + string);
    }
}

