/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.doc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.tools.indexer.Indexer;
import org.h2.util.IOUtils;
import org.h2.web.PageParser;

public class GenerateDoc {
    String inDir = "src/docsrc/html";
    String outDir = "docs/html";
    Connection conn;
    HashMap session = new HashMap();
    Bnf bnf;

    public static void main(String[] args) throws Exception {
        new GenerateDoc().run(args);
    }

    void run(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-in")) {
                this.inDir = args[++i];
                continue;
            }
            if (!args[i].equals("-out")) continue;
            this.outDir = args[++i];
        }
        Class.forName("org.h2.Driver");
        this.conn = DriverManager.getConnection("jdbc:h2:.");
        new File(this.outDir).mkdirs();
        this.bnf = Bnf.getInstance(null);
        this.map("commands", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION LIKE 'Commands%' ORDER BY ID");
        this.map("commandsDML", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION='Commands (DML)' ORDER BY ID");
        this.map("commandsDDL", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION='Commands (DDL)' ORDER BY ID");
        this.map("commandsOther", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION='Commands (Other)' ORDER BY ID");
        this.map("otherGrammar", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION='Other Grammar' ORDER BY ID");
        this.map("functionsAggregate", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION = 'Functions (Aggregate)' ORDER BY ID");
        this.map("functionsNumeric", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION = 'Functions (Numeric)' ORDER BY ID");
        this.map("functionsString", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION = 'Functions (String)' ORDER BY ID");
        this.map("functionsTimeDate", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION = 'Functions (Time and Date)' ORDER BY ID");
        this.map("functionsSystem", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION = 'Functions (System)' ORDER BY ID");
        this.map("functionsAll", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION LIKE 'Functions%' ORDER BY SECTION, ID");
        this.map("dataTypes", "SELECT * FROM INFORMATION_SCHEMA.HELP WHERE SECTION LIKE 'Data Types%' ORDER BY SECTION, ID");
        this.process("grammar");
        this.process("functions");
        this.process("datatypes");
        this.conn.close();
        Indexer.main(new String[0]);
    }

    void process(String fileName) throws Exception {
        FileOutputStream fout = new FileOutputStream(this.outDir + "/" + fileName + ".html");
        FileInputStream fin = new FileInputStream(this.inDir + "/" + fileName + ".jsp");
        byte[] bytes = IOUtils.readBytesAndClose(fin, 0);
        String page = new String(bytes);
        page = PageParser.parse(null, page, this.session);
        fout.write(page.getBytes());
        fout.close();
    }

    void map(String key, String sql) throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery(sql);
        ArrayList list = new ArrayList();
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 0; i < meta.getColumnCount(); ++i) {
                String k = meta.getColumnLabel(i + 1).toLowerCase();
                String value = rs.getString(i + 1);
                map.put(k, PageParser.escapeHtml(value));
            }
            String topic = rs.getString("TOPIC");
            String syntax = rs.getString("SYNTAX");
            syntax = this.bnf.getSyntax(topic, syntax);
            map.put("syntax", syntax);
            list.add(map);
        }
        this.session.put(key, list);
    }
}

