/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.code;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import org.h2.util.ByteUtils;

public class CheckTextFiles {
    String[] suffixCheck = new String[]{"html", "jsp", "js", "css", "bat", "nsi", "java", "txt", "properties", "cpp", "def", "h", "rc", "dev", "sql", "xml", "csv", "Driver"};
    String[] suffixIgnore = new String[]{"gif", "png", "odg", "ico", "sxd", "layout", "res", "win", "dll", "jar"};
    boolean failOnError = false;
    boolean allowTab = false;
    boolean allowCR = true;
    boolean allowTrailingSpaces = true;
    int spacesPerTab = 4;
    boolean autoFix = true;
    boolean useCRLF = true;
    String copyrightLicense = "Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).";
    String[] suffixIgnoreLicense = new String[]{"bat", "nsi", "txt", "properties", "def", "rc", "dev", "xml", "_private.h", "java.sql.Driver"};
    boolean hasError;

    public static void main(String[] args) throws Exception {
        new CheckTextFiles().run();
    }

    void run() throws Exception {
        String baseDir = "src";
        this.check(new File(baseDir));
        if (this.hasError) {
            throw new Exception("Errors found");
        }
    }

    private void check(File file) throws Exception {
        String name = file.getName();
        if (file.isDirectory()) {
            if (name.equals("CVS") || name.equals(".svn")) {
                return;
            }
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                this.check(list[i]);
            }
        } else {
            int i;
            String suffix = "";
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0) {
                suffix = name.substring(lastDot + 1);
            }
            boolean check = false;
            boolean ignore = false;
            for (i = 0; i < this.suffixCheck.length; ++i) {
                if (!suffix.equals(this.suffixCheck[i])) continue;
                check = true;
            }
            for (i = 0; i < this.suffixIgnore.length; ++i) {
                if (!suffix.equals(this.suffixIgnore[i])) continue;
                ignore = true;
            }
            boolean checkLicense = true;
            for (int i2 = 0; i2 < this.suffixIgnoreLicense.length; ++i2) {
                String ig = this.suffixIgnoreLicense[i2];
                if (!suffix.equals(ig) && !name.endsWith(ig)) continue;
                checkLicense = false;
                break;
            }
            if (ignore == check) {
                throw new Error("Unknown suffix: " + suffix + " for file: " + name);
            }
            if (check) {
                this.checkOrFixFile(file, this.autoFix, checkLicense);
            }
        }
    }

    void checkOrFixFile(File file, boolean fix, boolean checkLicense) throws Exception {
        byte[] changed;
        String text;
        RandomAccessFile in = new RandomAccessFile(file, "r");
        byte[] data = new byte[(int)file.length()];
        ByteArrayOutputStream out = fix ? new ByteArrayOutputStream() : null;
        in.readFully(data);
        in.close();
        if (checkLicense && data.length > this.copyrightLicense.length() && (text = new String(data)).indexOf(this.copyrightLicense) < 0) {
            this.fail(file, "license is missing", 0);
        }
        int line = 1;
        boolean lastWasWhitespace = false;
        for (int i = 0; i < data.length; ++i) {
            char ch = (char)(data[i] & 0xFF);
            if (ch > '\u007f') {
                this.fail(file, "contains character " + ch, line);
                return;
            }
            if (ch < ' ') {
                if (ch == '\n') {
                    if (lastWasWhitespace && !this.allowTrailingSpaces) {
                        this.fail(file, "contains trailing white space", line);
                        return;
                    }
                    if (fix) {
                        if (this.useCRLF) {
                            out.write(13);
                        }
                        out.write(ch);
                    }
                    lastWasWhitespace = false;
                    ++line;
                    continue;
                }
                if (ch == '\r') {
                    if (!this.allowCR) {
                        this.fail(file, "contains CR", line);
                        return;
                    }
                    if (lastWasWhitespace && !this.allowTrailingSpaces) {
                        this.fail(file, "contains trailing white space", line);
                        return;
                    }
                    lastWasWhitespace = false;
                    continue;
                }
                if (ch == '\t') {
                    if (fix) {
                        for (int j = 0; j < this.spacesPerTab; ++j) {
                            out.write(32);
                        }
                    } else if (!this.allowTab) {
                        this.fail(file, "contains TAB", line);
                        return;
                    }
                    lastWasWhitespace = true;
                    continue;
                }
                this.fail(file, "contains character " + ch, line);
                return;
            }
            if (fix) {
                out.write(ch);
            }
            lastWasWhitespace = Character.isWhitespace(ch);
        }
        if (lastWasWhitespace && !this.allowTrailingSpaces) {
            this.fail(file, "contains trailing white space at the very end", line);
            return;
        }
        if (fix && ByteUtils.compareNotNull(data, changed = out.toByteArray()) != 0) {
            RandomAccessFile f = new RandomAccessFile(file, "rw");
            f.write(changed);
            f.setLength(changed.length);
            f.close();
            System.out.println("CHANGED: File " + file.getName());
        }
    }

    private void fail(File file, String error, int line) {
        System.out.println("FAIL: File " + file.getAbsolutePath() + " " + error + " at line " + line);
        this.hasError = true;
        if (this.failOnError) {
            throw new Error("FAIL");
        }
    }
}

