/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;

public class JdbcStatement
extends TraceObject
implements Statement {
    protected JdbcConnection conn;
    protected SessionInterface session;
    protected JdbcResultSet resultSet;
    protected int maxRows;
    protected boolean escapeProcessing = true;
    protected int queryTimeout;
    protected boolean queryTimeoutSet;
    protected int fetchSize;
    protected boolean fetchSizeSet;
    protected int updateCount;
    private CommandInterface executingCommand;
    private ObjectArray batchCommands;
    protected int resultSetType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            ResultInterface result;
            int id = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeAssign("ResultSet", 4, id);
                this.debugCodeCall("executeQuery", sql);
            }
            this.checkClosed();
            this.closeOld();
            if (this.escapeProcessing) {
                sql = this.conn.translateSQL(sql);
            }
            CommandInterface command = this.conn.prepareCommand(sql);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(command);
                try {
                    boolean scrollable = this.resultSetType != 1003;
                    result = command.executeQuery(this.maxRows, scrollable);
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            command.close();
            this.resultSet = new JdbcResultSet(this.session, this.conn, this, result, id);
            return this.resultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", sql);
            this.checkClosed();
            this.closeOld();
            if (this.escapeProcessing) {
                sql = this.conn.translateSQL(sql);
            }
            CommandInterface command = this.conn.prepareCommand(sql);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(command);
                try {
                    this.updateCount = command.executeUpdate();
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            command.close();
            return this.updateCount;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        try {
            boolean returnsResultSet;
            int id = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeCall("execute", sql);
            }
            this.checkClosed();
            this.closeOld();
            if (this.escapeProcessing) {
                sql = this.conn.translateSQL(sql);
            }
            CommandInterface command = this.conn.prepareCommand(sql);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(command);
                try {
                    if (command.isQuery()) {
                        returnsResultSet = true;
                        boolean scrollable = this.resultSetType != 1003;
                        ResultInterface result = command.executeQuery(this.maxRows, scrollable);
                        this.resultSet = new JdbcResultSet(this.session, this.conn, this, result, id);
                    } else {
                        returnsResultSet = false;
                        this.updateCount = command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            command.close();
            return returnsResultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet != null) {
                int id = this.resultSet.getTraceId();
                this.debugCodeAssign("ResultSet", 4, id);
            }
            this.debugCodeCall("getResultSet");
            return this.resultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeOld();
            if (this.conn != null) {
                this.conn = null;
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            this.debugCodeCall("getConnection");
            this.checkClosed();
            return this.conn;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            this.checkClosed();
            this.closeOld();
            return false;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setCursorName(String name) throws SQLException {
        try {
            this.debugCodeCall("setCursorName", name);
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", direction);
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setMaxRows(int maxRows) throws SQLException {
        try {
            this.debugCodeCall("setMaxRows", maxRows);
            this.checkClosed();
            if (maxRows < 0) {
                throw Message.getInvalidValueException("" + maxRows, "maxRows");
            }
            this.maxRows = maxRows;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", rows);
            this.checkClosed();
            if (rows < 0 || rows > 0 && this.maxRows > 0 && rows > this.maxRows) {
                throw Message.getInvalidValueException("" + rows, "rows");
            }
            this.fetchSize = rows;
            this.fetchSizeSet = true;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getResultSetConcurrency");
            this.checkClosed();
            return 1008;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            this.debugCodeCall("getResultSetType");
            this.checkClosed();
            return this.resultSetType;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            this.debugCodeCall("getMaxFieldSize");
            this.checkClosed();
            return 0;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.debugCodeCall("setMaxFieldSize", max);
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setEscapeProcessing(" + enable + ");");
            }
            this.checkClosed();
            this.escapeProcessing = enable;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        try {
            this.debugCodeCall("cancel");
            this.checkClosed();
            CommandInterface c = this.executingCommand;
            try {
                if (c != null) {
                    c.cancel();
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            return this.queryTimeout;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", seconds);
            this.checkClosed();
            if (seconds < 0) {
                throw Message.getInvalidValueException("" + seconds, "seconds");
            }
            this.queryTimeout = seconds;
            this.queryTimeoutSet = true;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void addBatch(String sql) throws SQLException {
        try {
            this.debugCodeCall("addBatch", sql);
            this.checkClosed();
            if (this.escapeProcessing) {
                sql = this.conn.translateSQL(sql);
            }
            if (this.batchCommands == null) {
                this.batchCommands = new ObjectArray();
            }
            this.batchCommands.add(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchCommands = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            this.checkClosed();
            if (this.batchCommands == null) {
                this.batchCommands = new ObjectArray();
            }
            int[] result = new int[this.batchCommands.size()];
            boolean error = false;
            for (int i = 0; i < this.batchCommands.size(); ++i) {
                String sql = (String)this.batchCommands.get(i);
                try {
                    result[i] = this.executeUpdate(sql);
                    continue;
                }
                catch (SQLException e) {
                    this.logAndConvert(e);
                    result[i] = -3;
                    error = true;
                }
            }
            this.batchCommands = null;
            if (error) {
                throw new BatchUpdateException(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            this.debugCodeCall("getGeneratedKeys");
            this.checkClosed();
            return this.conn.getGeneratedKeys(this);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            return this.executeUpdate(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            return this.executeUpdate(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            return this.executeUpdate(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            return this.execute(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            return this.execute(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            return this.execute(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            this.debugCodeCall("getResultSetHoldability");
            this.checkClosed();
            return 1;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    JdbcStatement(SessionInterface session, JdbcConnection conn, int resultSetType, int id) {
        this.setTrace(session.getTrace(), 8, id);
        this.session = session;
        this.conn = conn;
        this.resultSetType = resultSetType;
    }

    void checkClosed() throws SQLException {
        if (this.conn == null) {
            throw Message.getSQLException(90007);
        }
        this.conn.checkClosed();
    }

    void closeOld() {
        if (this.resultSet != null) {
            this.resultSet.closeInternal();
            this.resultSet = null;
        }
        this.updateCount = -1;
    }

    protected void setExecutingStatement(CommandInterface c) {
        this.conn.setExecutingStatement(c == null ? null : this);
        this.executingCommand = c;
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.conn == null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }
}

