/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

public class JdbcResultSetMetaData
extends TraceObject
implements ResultSetMetaData {
    private JdbcResultSet rs;
    private ResultInterface result;

    public int getColumnCount() throws SQLException {
        try {
            this.debugCodeCall("getColumnCount");
            this.checkClosed();
            return this.result.getVisibleColumnCount();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getColumnLabel(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnLabel", column);
            this.rs.checkColumnIndex(column);
            return this.result.getAlias(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getColumnName(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnName", column);
            this.rs.checkColumnIndex(column);
            return this.result.getColumnName(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getColumnType(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnType", column);
            this.rs.checkColumnIndex(column);
            int type = this.result.getColumnType(--column);
            return DataType.convertTypeToSQLType(type);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getColumnTypeName(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnTypeName", column);
            this.rs.checkColumnIndex(column);
            int type = this.result.getColumnType(--column);
            return DataType.getDataType((int)type).name;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getSchemaName(int column) throws SQLException {
        try {
            this.debugCodeCall("getSchemaName", column);
            this.rs.checkColumnIndex(column);
            return this.result.getSchemaName(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getTableName(int column) throws SQLException {
        try {
            this.debugCodeCall("getTableName", column);
            this.rs.checkColumnIndex(column);
            return this.result.getTableName(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getCatalogName(int column) throws SQLException {
        try {
            this.debugCodeCall("getCatalogName", column);
            this.rs.checkColumnIndex(column);
            return this.rs.getConnection().getCatalog();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        try {
            this.debugCodeCall("isAutoIncrement", column);
            this.rs.checkColumnIndex(column);
            return this.result.isAutoIncrement(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        try {
            this.debugCodeCall("isCaseSensitive", column);
            this.rs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isSearchable(int column) throws SQLException {
        try {
            this.debugCodeCall("isSearchable", column);
            this.rs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isCurrency(int column) throws SQLException {
        try {
            this.debugCodeCall("isCurrency", column);
            this.rs.checkColumnIndex(column);
            return false;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int isNullable(int column) throws SQLException {
        try {
            this.debugCodeCall("isNullable", column);
            this.rs.checkColumnIndex(column);
            return this.result.getNullable(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isSigned(int column) throws SQLException {
        try {
            this.debugCodeCall("isSigned", column);
            this.rs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isReadOnly(int column) throws SQLException {
        try {
            this.debugCodeCall("isReadOnly", column);
            this.rs.checkColumnIndex(column);
            return false;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isWritable(int column) throws SQLException {
        try {
            this.debugCodeCall("isWritable", column);
            this.rs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        try {
            this.debugCodeCall("isDefinitelyWritable", column);
            this.rs.checkColumnIndex(column);
            return false;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getColumnClassName(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnClassName", column);
            this.rs.checkColumnIndex(column);
            int type = this.result.getColumnType(--column);
            return DataType.getTypeClassName(type);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getPrecision(int column) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", column);
            this.rs.checkColumnIndex(column);
            long prec = this.result.getColumnPrecision(--column);
            return MathUtils.convertLongToInt(prec);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getScale(int column) throws SQLException {
        try {
            this.debugCodeCall("getScale", column);
            this.rs.checkColumnIndex(column);
            return this.result.getColumnScale(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnDisplaySize", column);
            this.rs.checkColumnIndex(column);
            return this.result.getDisplaySize(--column);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    JdbcResultSetMetaData(JdbcResultSet rs, ResultInterface result, Trace trace, int id) {
        this.setTrace(trace, 5, id);
        this.rs = rs;
        this.result = result;
    }

    void checkClosed() throws SQLException {
        this.rs.checkClosed();
    }
}

