/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.value.Value;

public class JdbcBlob
extends TraceObject
implements Blob {
    private Value value;
    private JdbcConnection conn;

    public JdbcBlob(SessionInterface session, JdbcConnection conn, Value value, int id) {
        this.setTrace(session.getTrace(), 4, id);
        this.conn = conn;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        try {
            long precision;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 15 && (precision = this.value.getPrecision()) > 0L) {
                return precision;
            }
            long size = 0L;
            InputStream in = this.value.getInputStream();
            try {
                int len;
                byte[] buff = new byte[16];
                while ((len = in.read(buff, 0, 16)) > 0) {
                    size += (long)len;
                }
            }
            finally {
                in.close();
            }
            return size;
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
    }

    public void truncate(long len) throws SQLException {
        this.debugCodeCall("truncate", len);
        throw Message.getUnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            this.debugCode("getBytes(" + pos + ", " + length + ");");
            this.checkClosed();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = this.value.getInputStream();
            try {
                in.skip(pos - 1L);
                while (length > 0) {
                    int x = in.read();
                    if (x < 0) {
                        break;
                    }
                    out.write(x);
                    --length;
                }
            }
            finally {
                in.close();
            }
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.debugCode("setBytes(" + pos + ", bytes);");
        throw Message.getUnsupportedException();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.debugCode("setBytes(" + pos + ", bytes, " + offset + ", " + len + ");");
        throw Message.getUnsupportedException();
    }

    public InputStream getBinaryStream() throws SQLException {
        this.debugCodeCall("getBinaryStream");
        return this.value.getInputStream();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.debugCodeCall("setBinaryStream", pos);
        throw Message.getUnsupportedException();
    }

    public long position(byte[] pattern, long start) throws SQLException {
        this.debugCode("position(pattern, " + start + ");");
        throw Message.getUnsupportedException();
    }

    public long position(Blob blobPattern, long start) throws SQLException {
        this.debugCode("position(blobPattern, " + start + ");");
        throw Message.getUnsupportedException();
    }

    public void free() throws SQLException {
        this.debugCodeCall("free");
        this.value = null;
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.debugCode("getBinaryStream(" + pos + ", " + length + ");");
        throw Message.getUnsupportedException();
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
        if (this.value == null) {
            throw Message.getSQLException(90007);
        }
    }
}

