/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewCursor;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class ViewIndex
extends Index {
    private String querySQL;
    private ObjectArray originalParameters;
    private Parameter[] params;
    private Value[] lastValues;
    private LocalResult lastResult;

    public ViewIndex(TableView view, String querySQL, ObjectArray originalParameters) {
        super(view, 0, null, null, IndexType.createNonUnique(false));
        this.querySQL = querySQL;
        this.originalParameters = originalParameters;
    }

    public String getPlanSQL() {
        return this.querySQL;
    }

    public void close(Session session) throws SQLException {
    }

    public void add(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void remove(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    private int getComparisonType(int mask) {
        if ((mask & 1) == 1) {
            return 0;
        }
        if ((mask & 6) == 6) {
            return 1;
        }
        if ((mask & 2) == 2) {
            return 1;
        }
        if ((mask & 4) == 4) {
            return 3;
        }
        throw Message.internal("unsupported mask " + mask);
    }

    public Query getQuery(Session session, int[] masks) throws SQLException {
        Query query = (Query)session.prepare(this.querySQL, true);
        IntArray paramIndex = new IntArray();
        if (masks == null) {
            double cost = query.getCost();
            PlanItem item = new PlanItem();
            item.cost = cost;
            this.columns = new Column[0];
            this.params = new Parameter[0];
            return query;
        }
        for (int i = 0; i < masks.length; ++i) {
            int mask = masks[i];
            if (mask == 0) continue;
            paramIndex.add(i);
        }
        int len = paramIndex.size();
        this.columns = new Column[len];
        this.params = new Parameter[len];
        for (int i = 0; i < len; ++i) {
            Parameter param;
            Column col;
            int idx = paramIndex.get(i);
            this.columns[i] = col = this.table.getColumn(idx);
            this.params[i] = param = new Parameter(0);
            int mask = masks[idx];
            int comparisonType = this.getComparisonType(mask);
            query.addGlobalCondition(param, idx, comparisonType);
        }
        String sql = query.getSQL();
        query = (Query)session.prepare(sql);
        return query;
    }

    public Cursor find(Session session, Row first, Row last) throws SQLException {
        LocalResult result;
        Value v;
        int i;
        Query query = (Query)session.prepare(this.querySQL, true);
        ObjectArray params = query.getParameters();
        for (i = 0; first != null && i < first.getColumnCount(); ++i) {
            v = first.getValue(i);
            if (v == null) continue;
            query.addGlobalCondition(ValueExpression.get(v), i, 1);
        }
        for (i = 0; last != null && i < last.getColumnCount(); ++i) {
            v = last.getValue(i);
            if (v == null) continue;
            query.addGlobalCondition(ValueExpression.get(v), i, 3);
        }
        boolean sameAsLast = query.isEverything(2) ? this.lastResult != null && first == null && last == null : false;
        for (int i2 = 0; this.originalParameters != null && i2 < this.originalParameters.size(); ++i2) {
            Parameter orig = (Parameter)this.originalParameters.get(i2);
            Parameter param = (Parameter)params.get(i2);
            Value value = orig.getValue(session);
            if (sameAsLast && !session.getDatabase().areEqual(value, this.lastValues[i2])) {
                sameAsLast = false;
            }
            if (this.lastValues == null) {
                this.lastValues = new Value[this.originalParameters.size()];
            }
            this.lastValues[i2] = value;
            param.setValue(value);
        }
        if (sameAsLast) {
            result = this.lastResult;
            result.reset();
        } else {
            query.setSession(session);
            this.lastResult = result = query.query(0);
        }
        return new ViewCursor(this.table, result);
    }

    public int getCost(int[] masks) throws SQLException {
        if (masks != null) {
            throw Message.getUnsupportedException();
        }
        return Integer.MAX_VALUE;
    }

    public void remove(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return false;
    }

    public Value findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }
}

