/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Comparator;
import org.h2.command.Parser;
import org.h2.command.dml.ScriptBase;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserDataType;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.ByteUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class Script
extends ScriptBase {
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private LocalResult result;
    private byte[] lineSeparator;
    private byte[] buffer;

    public Script(Session session) {
        super(session);
    }

    public boolean isQuery() {
        return true;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public void setPasswords(boolean passwords) {
        this.passwords = passwords;
    }

    public void setSettings(boolean settings) {
        this.settings = settings;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public LocalResult query(int maxrows) throws SQLException {
        this.session.getUser().checkAdmin();
        this.reset();
        try {
            int i;
            int i2;
            ObjectArray cols = new ObjectArray();
            cols.add(new ExpressionColumn(this.session.getDatabase(), null, new Column("SCRIPT", 13, 0L, 0)));
            this.result = new LocalResult(this.session, cols, 1);
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            Database db = this.session.getDatabase();
            if (this.settings) {
                ObjectArray settings = db.getAllSettings();
                for (i2 = 0; i2 < settings.size(); ++i2) {
                    Setting setting = (Setting)settings.get(i2);
                    this.add(setting.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            ObjectArray users = db.getAllUsers();
            for (i2 = 0; i2 < users.size(); ++i2) {
                User user = (User)users.get(i2);
                this.add(user.getCreateSQL(this.passwords, true), false);
            }
            ObjectArray roles = db.getAllRoles();
            for (int i3 = 0; i3 < roles.size(); ++i3) {
                Role role = (Role)roles.get(i3);
                this.add(role.getCreateSQL(), false);
            }
            ObjectArray schemas = db.getAllSchemas();
            for (int i4 = 0; i4 < schemas.size(); ++i4) {
                Schema schema = (Schema)schemas.get(i4);
                this.add(schema.getCreateSQL(), false);
            }
            ObjectArray datatypes = db.getAllUserDataTypes();
            for (int i5 = 0; i5 < datatypes.size(); ++i5) {
                UserDataType datatype = (UserDataType)datatypes.get(i5);
                this.add(datatype.getCreateSQL(), false);
            }
            ObjectArray constants = db.getAllSchemaObjects(11);
            for (int i6 = 0; i6 < constants.size(); ++i6) {
                Constant constant = (Constant)constants.get(i6);
                this.add(constant.getCreateSQL(), false);
            }
            ObjectArray functionAliases = db.getAllFunctionAliases();
            for (int i7 = 0; i7 < functionAliases.size(); ++i7) {
                FunctionAlias alias = (FunctionAlias)functionAliases.get(i7);
                this.add(alias.getCreateSQL(), false);
            }
            ObjectArray tables = db.getAllSchemaObjects(0);
            tables.sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Table t1 = (Table)o1;
                    Table t2 = (Table)o2;
                    return t1.getId() - t2.getId();
                }
            });
            for (int i8 = 0; i8 < tables.size(); ++i8) {
                Table table = (Table)tables.get(i8);
                table.lock(this.session, false);
                String sql = table.getCreateSQL();
                if (sql == null) continue;
                String tableType = table.getTableType();
                if (!this.drop) continue;
                if ("VIEW".equals(tableType)) {
                    this.add("DROP VIEW IF EXISTS " + table.getSQL(), false);
                    continue;
                }
                this.add("DROP TABLE IF EXISTS " + table.getSQL(), false);
            }
            ObjectArray sequences = db.getAllSchemaObjects(3);
            for (i = 0; i < sequences.size(); ++i) {
                Sequence sequence = (Sequence)sequences.get(i);
                if (this.drop && !sequence.getBelongsToTable()) {
                    this.add("DROP SEQUENCE IF EXISTS " + sequence.getSQL(), false);
                }
                this.add(sequence.getCreateSQL(), false);
            }
            for (i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                table.lock(this.session, false);
                String sql = table.getCreateSQL();
                if (sql == null) continue;
                String tableType = table.getTableType();
                this.add(sql, false);
                if (this.data && "TABLE".equals(tableType)) {
                    PlanItem plan = table.getBestPlanItem(this.session, null);
                    Index index = plan.getIndex();
                    Cursor cursor = index.find(this.session, null, null);
                    Column[] columns = table.getColumns();
                    String ins = "INSERT INTO " + table.getSQL() + "(";
                    for (int j = 0; j < columns.length; ++j) {
                        if (j > 0) {
                            ins = ins + ", ";
                        }
                        ins = ins + Parser.quoteIdentifier(columns[j].getName());
                    }
                    ins = ins + ") VALUES(";
                    while (cursor.next()) {
                        Row row = cursor.get();
                        String s = ins;
                        for (int j = 0; j < row.getColumnCount(); ++j) {
                            if (j > 0) {
                                s = s + ", ";
                            }
                            s = s + row.getValue(j).getSQL();
                        }
                        s = s + ")";
                        this.add(s, true);
                    }
                }
                ObjectArray indexes = table.getIndexes();
                for (int j = 0; indexes != null && j < indexes.size(); ++j) {
                    Index index = (Index)indexes.get(j);
                    if (index.getIndexType().belongsToConstraint()) continue;
                    this.add(index.getCreateSQL(), false);
                }
            }
            ObjectArray constraints = db.getAllSchemaObjects(5);
            for (int i9 = 0; i9 < constraints.size(); ++i9) {
                Constraint constraint = (Constraint)constraints.get(i9);
                this.add(constraint.getCreateSQLWithoutIndexes(), false);
            }
            ObjectArray triggers = db.getAllSchemaObjects(4);
            for (int i10 = 0; i10 < triggers.size(); ++i10) {
                TriggerObject trigger = (TriggerObject)triggers.get(i10);
                this.add(trigger.getCreateSQL(), false);
            }
            ObjectArray rights = db.getAllRights();
            for (int i11 = 0; i11 < rights.size(); ++i11) {
                Right right = (Right)rights.get(i11);
                this.add(right.getCreateSQL(), false);
            }
            this.closeIO();
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        LocalResult r = this.result;
        this.reset();
        return r;
    }

    private void reset() throws SQLException {
        this.result = null;
        this.buffer = null;
        this.lineSeparator = StringUtils.utf8Encode(System.getProperty("line.separator"));
    }

    private void add(String s, boolean insert) throws SQLException, IOException {
        if (s == null) {
            return;
        }
        if (this.out != null) {
            byte[] buff = StringUtils.utf8Encode(s + ";");
            int len = MathUtils.roundUp(buff.length + this.lineSeparator.length, 16);
            this.buffer = ByteUtils.copy(buff, this.buffer);
            if (len > this.buffer.length) {
                this.buffer = new byte[len];
            }
            System.arraycopy(buff, 0, this.buffer, 0, buff.length);
            for (int i = buff.length; i < len - this.lineSeparator.length; ++i) {
                this.buffer[i] = 32;
            }
            int j = 0;
            int i = len - this.lineSeparator.length;
            while (i < len) {
                this.buffer[i] = this.lineSeparator[j];
                ++i;
                ++j;
            }
            this.out.write(this.buffer, 0, len);
            if (!insert) {
                Value[] row = new Value[]{ValueString.get(s)};
                this.result.addRow(row);
            }
        } else {
            Value[] row = new Value[]{ValueString.get(s)};
            this.result.addRow(row);
        }
    }
}

