/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;

public class AlterTableAddConstraint
extends SchemaCommand {
    public static final int CHECK = 0;
    public static final int UNIQUE = 1;
    public static final int REFERENTIAL = 2;
    public static final int PRIMARY_KEY = 3;
    public static final int REFERENTIAL_INTEGRITY_TRUE = 4;
    public static final int REFERENTIAL_INTEGRITY_FALSE = 5;
    private int type;
    private String constraintName;
    private String tableName;
    private String[] columnNames;
    private int deleteAction;
    private int updateAction;
    private Schema refSchema;
    private String refTableName;
    private String[] refColumnNames;
    private Expression checkExpression;
    private Index index;
    private Index refIndex;

    public AlterTableAddConstraint(Session session, Schema schema) {
        super(session, schema);
    }

    private String generateConstraintName(int id) throws SQLException {
        if (this.constraintName == null) {
            this.constraintName = this.getSchema().getUniqueConstraintName();
        }
        return this.constraintName;
    }

    /*
     * WARNING - void declaration
     */
    public int update() throws SQLException {
        void var2_15;
        this.session.commit();
        Database db = this.session.getDatabase();
        if (this.getSchema().findConstraint(this.constraintName) != null) {
            throw Message.getSQLException(90045, this.constraintName);
        }
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true);
        switch (this.type) {
            case 0: {
                int id = this.getObjectId(true, true);
                String name = this.generateConstraintName(id);
                ConstraintCheck check = new ConstraintCheck(this.getSchema(), id, name, table);
                TableFilter filter = new TableFilter(this.session, table, null, false);
                this.checkExpression.mapColumns(filter, 0);
                this.checkExpression = this.checkExpression.optimize(this.session);
                check.setExpression(this.checkExpression);
                check.setTableFilter(filter);
                Constraint constraint = check;
                break;
            }
            case 1: {
                Column[] columns = table.getColumns(this.columnNames);
                boolean isOwner = false;
                if (this.index != null && this.canUseUniqueIndex(this.index, table, columns)) {
                    isOwner = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = this.getUniqueIndex(table, columns);
                    if (this.index == null) {
                        this.index = this.createIndex(table, columns, true);
                        isOwner = true;
                    }
                }
                int id = this.getObjectId(true, true);
                String name = this.generateConstraintName(id);
                ConstraintUnique unique = new ConstraintUnique(this.getSchema(), id, name, table);
                unique.setColumns(columns);
                unique.setIndex(this.index, isOwner);
                Constraint constraint = unique;
                break;
            }
            case 2: {
                Column[] refColumns;
                Table refTable = this.refSchema.getTableOrView(this.session, this.refTableName);
                this.session.getUser().checkRight(refTable, 15);
                boolean isOwner = false;
                Column[] columns = table.getColumns(this.columnNames);
                if (this.index != null && this.canUseIndex(this.index, table, columns)) {
                    isOwner = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = this.getIndex(table, columns);
                    if (this.index == null) {
                        this.index = this.createIndex(table, columns, false);
                        isOwner = true;
                    }
                }
                if (this.refColumnNames == null) {
                    Index refIdx = refTable.getPrimaryKey();
                    refColumns = refIdx.getColumns();
                } else {
                    refColumns = refTable.getColumns(this.refColumnNames);
                }
                if (refColumns.length != columns.length) {
                    throw Message.getSQLException(21002);
                }
                boolean isRefOwner = false;
                if (this.refIndex != null && this.refIndex.getTable() == refTable) {
                    isRefOwner = true;
                    this.refIndex.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.refIndex = null;
                }
                if (this.refIndex == null) {
                    this.refIndex = this.getUniqueIndex(refTable, refColumns);
                    if (this.refIndex == null) {
                        this.refIndex = this.createIndex(refTable, refColumns, true);
                        isRefOwner = true;
                    }
                }
                int id = this.getObjectId(true, true);
                String name = this.generateConstraintName(id);
                ConstraintReferential ref = new ConstraintReferential(this.getSchema(), id, name, table);
                ref.setColumns(columns);
                ref.setIndex(this.index, isOwner);
                ref.setRefTable(refTable);
                ref.setRefColumns(refColumns);
                ref.setRefIndex(this.refIndex, isRefOwner);
                Constraint constraint = ref;
                refTable.addConstraint(constraint);
                ref.setDeleteAction(this.session, this.deleteAction);
                ref.setUpdateAction(this.session, this.updateAction);
                break;
            }
            case 4: {
                table.setCheckForeignKeyConstraints(true);
                return 0;
            }
            case 5: {
                table.setCheckForeignKeyConstraints(false);
                return 0;
            }
            default: {
                throw Message.internal("type=" + this.type);
            }
        }
        db.addSchemaObject(this.session, (SchemaObject)var2_15);
        table.addConstraint((Constraint)var2_15);
        return 0;
    }

    private Index createIndex(Table t, Column[] cols, boolean unique) throws SQLException {
        int indexId = this.getObjectId(true, false);
        IndexType indexType = unique ? IndexType.createUnique(t.isPersistent(), false) : IndexType.createNonUnique(t.isPersistent());
        indexType.setBelongsToConstraint(true);
        String prefix = this.constraintName == null ? "CONSTRAINT" : this.constraintName;
        String indexName = this.getSchema().getUniqueIndexName(prefix + "_INDEX_");
        return t.addIndex(this.session, indexName, indexId, cols, indexType, -1);
    }

    public void setDeleteAction(int action) {
        this.deleteAction = action;
    }

    public void setUpdateAction(int action) {
        this.updateAction = action;
    }

    private Index getUniqueIndex(Table t, Column[] cols) {
        ObjectArray list = t.getIndexes();
        for (int i = 0; i < list.size(); ++i) {
            Index index = (Index)list.get(i);
            if (!this.canUseUniqueIndex(index, t, cols)) continue;
            return index;
        }
        return null;
    }

    private boolean canUseUniqueIndex(Index index, Table table, Column[] cols) {
        if (index.getTable() != table || !index.getIndexType().isUnique()) {
            return false;
        }
        if (index.getIndexType().belongsToConstraint()) {
            return false;
        }
        Column[] indexCols = index.getColumns();
        if (indexCols.length > cols.length) {
            return false;
        }
        HashSet<Column> set = new HashSet<Column>(Arrays.asList(cols));
        for (int j = 0; j < indexCols.length; ++j) {
            if (set.contains(indexCols[j])) continue;
            return false;
        }
        return true;
    }

    private Index getIndex(Table t, Column[] cols) {
        ObjectArray list = t.getIndexes();
        for (int i = 0; i < list.size(); ++i) {
            Index index = (Index)list.get(i);
            if (!this.canUseIndex(index, t, cols)) continue;
            return index;
        }
        return null;
    }

    private boolean canUseIndex(Index index, Table table, Column[] cols) {
        if (index.getTable() != table || index.getCreateSQL() == null) {
            return false;
        }
        Column[] indexCols = index.getColumns();
        if (indexCols.length < cols.length) {
            return false;
        }
        for (int j = 0; j < cols.length; ++j) {
            int idx = index.getColumnIndex(cols[j]);
            if (idx >= 0 && idx < cols.length) continue;
            return false;
        }
        return true;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setCheckExpression(Expression expression) {
        this.checkExpression = expression;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setRefTableName(Schema refSchema, String ref) {
        this.refSchema = refSchema;
        this.refTableName = ref;
    }

    public void setRefColumnNames(String[] cols) {
        this.refColumnNames = cols;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setRefIndex(Index refIndex) {
        this.refIndex = refIndex;
    }
}

