/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.util;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jsdp.util.InvalidValueException;

public class Address
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3442566371424669052L;
    private static final Matcher fqdnMatcher = Pattern.compile("([a-zA-Z]+(([\\w-]+)*[\\w]+)*)+(\\.[a-zA-Z]+(([\\w-]+)*[\\w]+)*)*").matcher("");
    private static final String FQDN = "FQDN";
    public static final String IP4 = "IP4";
    public static final String IP6 = "IP6";
    protected String address;
    protected String addressType;

    protected Address() {
        try {
            this.setAddress(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public Address(String address) throws InvalidValueException {
        if (address == null) {
            throw new InvalidValueException("Invalid host name");
        }
        this.setAddress(address);
    }

    public Object clone() {
        Address host = new Address();
        host.addressType = this.addressType;
        host.address = new String(this.address);
        return host;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Address)) {
            return false;
        }
        Address otherHost = (Address)object;
        return otherHost.address.equalsIgnoreCase(this.address);
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddress(String address) throws InvalidValueException {
        if (Address.isFQDN(address)) {
            this.address = address;
            this.addressType = IP4;
        } else {
            try {
                InetAddress ip = InetAddress.getByName(address);
                this.addressType = ip instanceof Inet4Address ? IP4 : IP6;
                this.address = address;
            }
            catch (UnknownHostException invalidIP) {
                throw new InvalidValueException("Not IP4 or IP6 address !!");
            }
        }
    }

    public boolean isFQDN() {
        return this.addressType.compareTo(FQDN) == 0;
    }

    public static boolean isFQDN(String address) {
        fqdnMatcher.reset(address);
        return fqdnMatcher.matches();
    }

    public boolean isIPAddress() {
        return this.addressType.compareTo(FQDN) != 0;
    }

    public String toString() {
        return this.addressType + " " + this.address;
    }
}

