/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.tools.util;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import net.sourceforge.jsdp.tools.util.PopupListener;

public class ClipboardPopup
extends JPopupMenu {
    private static final long serialVersionUID = -2864496330830649340L;
    private final JTextComponent component;
    private final JMenuItem copy;
    private final JMenuItem cut;
    private final JMenuItem paste;
    private final JMenuItem delete;
    private final JMenuItem selectAll;

    public ClipboardPopup(JTextComponent textComponent) {
        this.component = textComponent;
        this.cut = this.add("Cut");
        this.cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ClipboardPopup.this.component.cut();
            }
        });
        this.copy = this.add("Copy");
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ClipboardPopup.this.component.copy();
            }
        });
        this.paste = this.add("Paste");
        this.paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClipboardPopup.this.component.paste();
            }
        });
        this.delete = this.add("Delete");
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ClipboardPopup.this.component.replaceSelection(null);
            }
        });
        this.addSeparator();
        this.selectAll = this.add("Select all");
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClipboardPopup.this.component.selectAll();
            }
        });
    }

    public static void addPopupToComponent(JTextComponent textComponent) {
        ClipboardPopup popup = new ClipboardPopup(textComponent);
        textComponent.addMouseListener(new PopupListener(popup));
    }

    public static boolean isClipboardEmpty(Object source) {
        boolean result = true;
        Transferable data = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(source);
        try {
            DataFlavor flavor = new DataFlavor(String.class, null);
            result = data.getTransferData(flavor) == null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void show(Component invoker, int x, int y) {
        boolean hasSelection = this.component.getSelectedText() != null;
        this.cut.setEnabled(hasSelection);
        this.copy.setEnabled(hasSelection);
        this.paste.setEnabled(!ClipboardPopup.isClipboardEmpty(this.component));
        this.delete.setEnabled(hasSelection);
        this.selectAll.setEnabled(this.component.getSelectedText() == null || this.component.getText().length() != this.component.getSelectedText().length());
        this.component.requestFocus();
        super.show(invoker, x, y);
    }
}

