/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.parser;

import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;

public class ConnectionParser
extends SdpFieldParser {
    public ConnectionParser(String input) {
        super(input);
    }

    public Field parse() throws UnexpectedFieldException, SdpException {
        if (!this.type.equals("c=")) {
            throw new UnexpectedFieldException("This is not an Connection field : " + this.type + this.value);
        }
        String[] values = this.value.split(" ");
        if (values.length != 3) {
            throw new SdpException("Invalid connection field syntax");
        }
        if (!values[0].equals("IN")) {
            throw new SdpException("Unknown NetType : " + values[0]);
        }
        if (!values[1].equals("IP4") && !values[1].equals("IP6")) {
            throw new SdpException("Unknown AddressType : " + values[1]);
        }
        return new Connection(values[2]);
    }
}

