/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.util.TypedTime;
import net.sourceforge.jsdp.util.ZoneAdjustment;

public class TimeZone
implements Field {
    private static final long serialVersionUID = -87926730273093503L;
    protected boolean isTyped;
    protected Hashtable adjustments;

    protected TimeZone() {
    }

    public TimeZone(Date time, long offset) {
        this(new ZoneAdjustment(time, offset));
    }

    public TimeZone(ZoneAdjustment adjustment) {
        this.adjustments = new Hashtable(3);
        this.addZoneAdjustment(adjustment);
        this.isTyped = true;
    }

    public void addZoneAdjustment(ZoneAdjustment adjustment) {
        this.adjustments.put(new Date(adjustment.getTime()), adjustment);
    }

    public void addZoneAdjustment(Date time, long offset) {
        this.adjustments.put(time, new ZoneAdjustment(time, offset));
    }

    public Object clone() {
        TimeZone field = new TimeZone();
        field.isTyped = this.isTyped;
        field.adjustments = (Hashtable)this.adjustments.clone();
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public char getFieldType() {
        return 'z';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer();
        Enumeration values = this.adjustments.elements();
        while (values.hasMoreElements()) {
            ZoneAdjustment adjustment = (ZoneAdjustment)values.nextElement();
            result.append(adjustment.getTime() + " ");
            if (this.isTyped) {
                result.append(TypedTime.toString(adjustment.getOffset()) + " ");
                continue;
            }
            result.append(adjustment.getOffset() + " ");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public Map getZoneAdjustments() {
        return this.adjustments;
    }

    public boolean isTypedTime() {
        return this.isTyped;
    }

    public void setTypedTime(boolean typedTime) {
        this.isTyped = typedTime;
    }

    public String toString() {
        return "z=" + this.getFieldValue();
    }
}

