/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.Vector;
import net.sourceforge.jsdp.Description;
import net.sourceforge.jsdp.RepeatTime;
import net.sourceforge.jsdp.SdpElement;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.Time;

public class TimeDescription
implements Description {
    private static final long serialVersionUID = 6860935545790980038L;
    protected Time t;
    protected Vector repeatTimes;

    public TimeDescription(Time timeField) throws SdpException {
        this.setTime(timeField);
        this.repeatTimes = new Vector();
    }

    public TimeDescription(TimeDescription timeDescriptionObject) {
        this.t = (Time)timeDescriptionObject.t.clone();
        this.repeatTimes = (Vector)timeDescriptionObject.repeatTimes.clone();
    }

    public Object clone() {
        return new TimeDescription(this);
    }

    public String encode() {
        StringBuffer result = new StringBuffer();
        result.append(this.t.encode());
        for (int j = 0; j < this.repeatTimes.size(); ++j) {
            SdpElement e = (SdpElement)this.repeatTimes.get(j);
            result.append(e.encode());
        }
        return result.toString();
    }

    public Time getTime() {
        return this.t;
    }

    public void setTime(Time t) throws SdpException {
        if (t == null) {
            throw new SdpException();
        }
        this.t = t;
    }

    public void addRepeatTime(RepeatTime field) throws SdpException {
        if (field == null) {
            throw new SdpException();
        }
        this.repeatTimes.add(field);
    }

    public void clearRepeatTimes() {
        this.repeatTimes.clear();
    }

    public RepeatTime[] getRepeatTimes() {
        return this.repeatTimes.toArray(new RepeatTime[this.repeatTimes.size()]);
    }

    public void setRepeatTimes(RepeatTime[] repeatTimes) throws SdpException {
        Vector<RepeatTime[]> repeatTimesTemp = new Vector<RepeatTime[]>(repeatTimes.length);
        for (int j = 0; j < repeatTimes.length; ++j) {
            if (repeatTimes[j] == null) {
                throw new SdpException();
            }
            repeatTimesTemp.add(repeatTimes);
        }
        this.repeatTimes = repeatTimesTemp;
    }

    public String toString() {
        return this.encode();
    }
}

