/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;

public class Key
implements Field {
    private static final long serialVersionUID = 1767674946938133759L;
    public static final String BASE64 = "base64";
    public static final String CLEAR = "clear";
    public static final String PROMPT = "prompt";
    public static final String URI = "uri";
    protected String method;
    protected String key;

    protected Key() {
    }

    public Key(String method, String key) throws SdpException {
        this.setMethod(method);
        this.setKey(key);
    }

    public Object clone() {
        Key field = new Key();
        field.method = new String(this.method);
        field.key = new String(this.key);
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public char getFieldType() {
        return 'k';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer();
        result.append(this.method);
        if (this.key != null) {
            result.append(":" + this.key);
        }
        return result.toString();
    }

    public String getKey() {
        return this.key;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public void setKey(String key) throws SdpException {
        boolean result = false;
        if (this.method.equals(BASE64)) {
            result = Pattern.matches("([\\w\\+/]{4})*([\\w\\+/]{2}==|[\\w\\+/]{3}=)*", key);
        } else if (this.method.equals(CLEAR)) {
            result = Pattern.matches("[\\w'-\\./:?#\\$&\\*;=@\\[\\]\\^_`\\{\\}\\|\\+\\~ \\t]+", key);
        } else if (this.method.equals(PROMPT)) {
            result = key.equals("");
            key = null;
        } else if (this.method.equals(URI)) {
            try {
                new URL(key);
            }
            catch (MalformedURLException invalidUrl) {
                result = false;
            }
        }
        if (!result) {
            throw new SdpException("Invalid key for the specified method : " + key);
        }
        this.key = key;
    }

    public void setMethod(String method) throws SdpException {
        if (method == null) {
            throw new SdpException("The method is null");
        }
        if (!(method.equals(BASE64) || method.equals(CLEAR) || method.equals(PROMPT) || method.equals(URI))) {
            throw new SdpException("The method " + method + " is not supported by SDP");
        }
        this.method = method;
    }

    public String toString() {
        return "k=" + this.getFieldValue();
    }
}

