/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.util.EmailAddress;
import net.sourceforge.jsdp.util.InvalidValueException;

public class Email
implements Field {
    private static final long serialVersionUID = 3055937612221619818L;
    protected EmailAddress mail;

    protected Email() {
    }

    public Email(String address) throws SdpException {
        try {
            this.mail = new EmailAddress(address);
        }
        catch (InvalidValueException noMailAddress) {
            throw new SdpException("Invalid email format : " + address);
        }
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public Object clone() {
        Email field = new Email();
        field.mail = (EmailAddress)this.mail.clone();
        return field;
    }

    public char getFieldType() {
        return 'e';
    }

    public String getFieldValue() {
        return this.mail.toString();
    }

    public String getEmail() {
        return this.mail.getAddress();
    }

    public String getPersonal() {
        return this.mail.getPersonal();
    }

    public void setEmail(String email) throws SdpException {
        this.mail.setAddress(email);
    }

    public void setPersonal(String personal) throws SdpException {
        this.mail.setPersonal(personal);
    }

    public String toString() {
        return "e=" + this.getFieldValue();
    }
}

