/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.util.Resource;

public class Connection
implements Field {
    private static final long serialVersionUID = 1555839237745744131L;
    public static final String IN = "IN";
    public static final String IP4 = "IP4";
    public static final String IP6 = "IP6";
    protected Resource resource;

    protected Connection() {
    }

    public Connection(String resource) throws SdpException {
        this.resource = new Resource(resource);
    }

    public Object clone() {
        Connection field = new Connection();
        field.resource = (Resource)this.resource.clone();
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public String getAddress() {
        return this.resource.getAddress();
    }

    public String getAddressType() {
        return this.resource.getAddressType();
    }

    public char getFieldType() {
        return 'c';
    }

    public String getFieldValue() {
        return "IN " + this.resource.toString();
    }

    public String getNetType() {
        return IN;
    }

    public void setAddress(String address) throws SdpException {
        this.resource.setAddress(address);
    }

    public void setAddress(String address, int ttl) throws SdpException {
        this.resource.setAddress(address);
        this.resource.setTTL(ttl);
    }

    public void setAddress(String address, int ttl, int addresses) throws SdpException {
        this.resource.setAddress(address);
        this.resource.setTTL(ttl);
        this.resource.setAddresses(addresses);
    }

    public String toString() {
        return "c=" + this.getFieldValue();
    }
}

