/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.List;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import tools.tracesviewer.TracesMessage;
import tools.tracesviewer.TracesSession;
import tools.tracesviewer.TracesSessions;
import tools.tracesviewer.TracesViewer;

public class TracesSessionsDisplayer
extends JFrame {
    public TracesSessions tracesSessions = null;
    public TextArea allmessagesTextArea;
    public List sessionsList;
    public JPanel mainPanel;
    public JButton okButton;

    public TracesSessionsDisplayer() {
        super("Sessions Displayer");
        this.initComponents();
    }

    public void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.setBackground(Color.black);
        this.setSize(650, 600);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.mainPanel = new JPanel();
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        this.allmessagesTextArea = new TextArea();
        this.allmessagesTextArea.setEditable(false);
        this.allmessagesTextArea.setFont(new Font("Dialog", 1, 12));
        this.allmessagesTextArea.setForeground(Color.black);
        this.allmessagesTextArea.append("Select a session in the list to view its messages");
        this.mainPanel.add((Component)this.allmessagesTextArea, "Center");
        this.sessionsList = new List();
        this.sessionsList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TracesSessionsDisplayer.this.showMessages(itemEvent);
            }
        });
        this.sessionsList.setForeground(Color.black);
        this.sessionsList.setFont(new Font("Dialog", 1, 14));
        this.mainPanel.add((Component)this.sessionsList, "West");
        this.okButton = new JButton("  OK  ");
        this.okButton.setToolTipText("Returns to the main frame");
        this.okButton.setFont(new Font("Dialog", 1, 16));
        this.okButton.setFocusPainted(false);
        this.okButton.setBackground(Color.lightGray);
        this.okButton.setBorder(new BevelBorder(0));
        this.okButton.setVerticalAlignment(0);
        this.okButton.setHorizontalAlignment(0);
        container.add((Component)this.okButton, "South");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TracesSessionsDisplayer.this.hide();
            }
        });
    }

    public static String getTrueName(String string) {
        try {
            int n = string.indexOf("//");
            int n2 = string.indexOf("/", 2);
            String string2 = string.substring(2, n2);
            if (string2.equals(TracesViewer.stackId)) {
                return "the proxy";
            }
            return "a user agent (" + string2 + ")";
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    public void setTracesSessions(TracesSessions tracesSessions) {
        this.sessionsList.removeAll();
        this.tracesSessions = tracesSessions;
        for (int i = 0; i < tracesSessions.size(); ++i) {
            TracesSession tracesSession = (TracesSession)tracesSessions.elementAt(i);
            String string = tracesSession.getName();
            if (string.equals("No available session yet, click on refresh")) {
                this.sessionsList.add(string);
                continue;
            }
            String string2 = TracesSessionsDisplayer.getTrueName(string);
            this.sessionsList.add("Trace " + (i + 1) + " from " + string2);
        }
        if (tracesSessions.size() != 0) {
            this.sessionsList.select(0);
        }
    }

    public void showMessages(ItemEvent itemEvent) {
        int n = 0;
        if (itemEvent != null) {
            n = (Integer)itemEvent.getItem();
        }
        this.allmessagesTextArea.setText("");
        TracesSession tracesSession = (TracesSession)this.tracesSessions.elementAt(n);
        for (int i = 0; i < tracesSession.size(); ++i) {
            TracesMessage tracesMessage = (TracesMessage)tracesSession.elementAt(i);
            this.allmessagesTextArea.append("Message " + (i + 1) + " from " + tracesMessage.getFrom() + " to " + tracesMessage.getTo());
            this.allmessagesTextArea.append("\n\n");
            this.allmessagesTextArea.append(tracesMessage.getMessageString());
            this.allmessagesTextArea.append("\n");
        }
        this.allmessagesTextArea.select(0, 0);
    }

    public void show(TracesSessions tracesSessions) {
        this.tracesSessions = tracesSessions;
        this.setTracesSessions(tracesSessions);
        this.showMessages(null);
        this.setVisible(true);
    }
}

