/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import tools.tracesviewer.LogComparator;
import tools.tracesviewer.MessageLogList;
import tools.tracesviewer.TracesMessage;

public class LogFileParser
extends DefaultHandler {
    protected Hashtable messageLogs = new Hashtable();
    private XMLReader xmlReader;
    private String transactionId;
    private String from;
    private String to;
    private String time;
    private String statusMessage;
    private String firstLine;
    private String callId;
    private String isSender;
    private String fileLocation;
    private StringBuffer message;
    public String logDescription;
    public String auxInfo;
    public String logName;
    private String currentTag;
    private String debugLine;
    private String previousDebug = null;
    private TracesMessage messageLog;

    public LogFileParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.xmlReader = sAXParser.getXMLReader();
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable parseLogs(InputSource inputSource) {
        try {
            this.xmlReader.parse(inputSource);
            return this.messageLogs;
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.messageLogs;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentTag = string3;
        if (string3.equalsIgnoreCase("debug")) {
            // empty if block
        }
        if (string3.equalsIgnoreCase("message")) {
            this.from = attributes.getValue("from");
            this.to = attributes.getValue("to");
            this.time = attributes.getValue("time");
            this.statusMessage = attributes.getValue("statusMessage");
            this.transactionId = attributes.getValue("transactionId");
            this.firstLine = attributes.getValue("firstLine");
            this.callId = attributes.getValue("callId");
            this.isSender = attributes.getValue("isSender");
            this.debugLine = attributes.getValue("debugLine");
            this.message = new StringBuffer();
        }
        if (string3.equalsIgnoreCase("description")) {
            this.logName = attributes.getValue("name");
            this.logDescription = attributes.getValue("logDescription");
            this.auxInfo = attributes.getValue("auxInfo");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("message")) {
            boolean bl = this.isSender.equals("true");
            this.messageLog = new TracesMessage(this.from, this.to, this.time, this.firstLine, this.message.toString(), this.statusMessage, this.transactionId, this.debugLine);
            MessageLogList messageLogList = (MessageLogList)this.messageLogs.get(this.callId);
            if (messageLogList == null) {
                messageLogList = new MessageLogList((Comparator)new LogComparator());
                this.messageLogs.put(this.callId, messageLogList);
            }
            messageLogList.add(this.messageLog);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        CharSequence charSequence;
        if (cArray == null) {
            return;
        }
        if (this.currentTag.equalsIgnoreCase("message")) {
            charSequence = new String(cArray, n, n2);
            if (((String)charSequence).equals("")) {
                return;
            }
            this.message.append((String)charSequence);
        }
        if (this.currentTag.equalsIgnoreCase("debug")) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(new String(cArray, n, n2));
            String string = ((StringBuffer)charSequence).toString().trim();
            if (string.equals("")) {
                return;
            }
            if (this.messageLog != null) {
                this.messageLog.beforeDebug = this.previousDebug;
                this.messageLog.afterDebug = string;
                this.previousDebug = string;
            } else {
                this.previousDebug = string;
            }
        }
    }

    public Hashtable parseLogsFromDebugFile(String string) {
        try {
            File file = new File(string);
            long l = file.length();
            char[] cArray = new char[(int)l];
            FileReader fileReader = new FileReader(file);
            fileReader.read(cArray);
            fileReader.close();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version='1.0' encoding='us-ascii'?>\n").append("<messages>\n").append(new String(cArray)).append("]]></debug></messages>\n");
            InputSource inputSource = new InputSource(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
            return this.parseLogs(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Hashtable parseLogsFromFile(String string) {
        try {
            File file = new File(string);
            long l = file.length();
            char[] cArray = new char[(int)l];
            FileReader fileReader = new FileReader(file);
            fileReader.read(cArray);
            fileReader.close();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version='1.0' encoding='us-ascii'?>\n").append("<messages>\n").append(new String(cArray)).append("</messages>\n");
            InputSource inputSource = new InputSource(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
            return this.parseLogs(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Hashtable parseLogsFromString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='us-ascii'?>\n").append("<messages>\n").append(string).append("</messages>\n");
        InputSource inputSource = new InputSource(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        return this.parseLogs(inputSource);
    }
}

