/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip.pidf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.sip.address.URI;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFFactory;
import jp.ac.naka.ec.sip.pidf.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIDFFactoryImpl
implements PIDFFactory {
    private EntityContainer con;
    private static SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-DD");
    private static SimpleDateFormat format2 = new SimpleDateFormat("kk:mm:ss");
    private static TimeZone timezone = TimeZone.getTimeZone("Europe/London");
    private static Calendar cal = Calendar.getInstance(timezone);
    private static final String pattern1 = "yyyy-MM-DD";
    private static final String pattern2 = "kk:mm:ss";
    private static final String zone = "Europe/London";

    public PIDFFactoryImpl(EntityContainer con) {
        this.con = con;
    }

    @Override
    public PIDFData createPIDF() {
        URI uri = this.con.getURI();
        PIDFData data = new PIDFData(uri);
        data.setName(this.con.getName());
        if (this.con.getLocation() != null) {
            data.setLocation(this.con.getLocation());
        }
        List<Tuple> tuples = this.createTuples();
        for (Tuple tuple : tuples) {
            data.addTuple(tuple);
        }
        return data;
    }

    private List<Tuple> createTuples() {
        Set<Entity> entities = this.con.getEntities();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (Entity entity : entities) {
            Tuple tuple = this.getTuple(entity);
            tuples.add(tuple);
            entity.setTupleId(tuple.id);
        }
        return tuples;
    }

    private Tuple getTuple(Entity e) {
        Date date = cal.getTime();
        Tuple tuple = new Tuple();
        tuple.contact = e.getURI();
        tuple.id = e.getName();
        EntityType ee = e.getEntityType();
        tuple.putExtension("type", ee.toString());
        tuple.putExtension("name", e.getName());
        tuple.putExtension("uri", e.getURI().toString());
        tuple.addNote(e.getDescription());
        float priority = e.getPriority();
        if (priority != 100.0f) {
            tuple.setPriority(priority);
        }
        tuple.timestamp = String.valueOf(format1.format(date)) + "T" + format2.format(date) + "Z";
        return tuple;
    }
}

