/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.ClientTransaction;
import javax.sip.ResponseEvent;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Response;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.SipCore;
import net.sourceforge.jsdp.SdpMessageParser;
import net.sourceforge.jsdp.SessionDescription;

public class ResponseDelegate {
    private EventDispatcher dispatcher = TupleSpaceAdapter.getInstance();
    private SipCore core = SipCore.getInstance();

    public boolean forward(ResponseEvent evt) {
        Response response = evt.getResponse();
        StatusCode code = this.getStatusCode(response.getStatusCode());
        boolean a = false;
        switch (code) {
            case CODE1xx: {
                break;
            }
            case CODE2xx: {
                this.doSuccessResponse(evt);
                a = true;
                break;
            }
            case CODE3xx: {
                break;
            }
            case CODE4xx: {
                break;
            }
            case CODE5xx: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return a;
    }

    public void doSuccessResponse(ResponseEvent evt) {
        Response res = evt.getResponse();
        try {
            CSeqHeader cseq = (CSeqHeader)res.getHeader("CSeq");
            if (res.getStatusCode() == 200) {
                if (cseq.getMethod().equals("INVITE")) {
                    FromHeader contact = (FromHeader)res.getHeader("From");
                    ToHeader to = (ToHeader)res.getHeader("To");
                    SipURI source_uri = (SipURI)contact.getAddress().getURI();
                    SipURI target_uri = (SipURI)to.getAddress().getURI();
                    EntityImpl source = new EntityImpl(source_uri);
                    EntityImpl target = new EntityImpl(target_uri);
                    target.setLocal(false);
                    SessionDescription sdp = null;
                    byte[] raw = res.getRawContent();
                    if (raw != null) {
                        String sdp_str = new String(raw, "UTF-8");
                        sdp = SdpMessageParser.getSessionDescription((String)sdp_str);
                    }
                    EntityEvent ee = new EntityEvent(sdp, (EntityListener)target, (Entity)source);
                    ee.setEventType(EntityEvent.EventType.ACK);
                    this.dispatcher.dispatchEvent(ee);
                    EntityEvent eee = new EntityEvent(sdp, (EntityListener)source, (Entity)target);
                    eee.setEventType(EntityEvent.EventType.ANSWER);
                    this.dispatcher.dispatchEvent(eee);
                } else if (cseq.getMethod().equals("NOTIFY")) {
                    this.core.refresh();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doErrorResponse(ResponseEvent evt) {
        System.err.println(evt.getResponse().toString());
        ClientTransaction ct = evt.getClientTransaction();
        if (ct == null) {
            return;
        }
        Response res = evt.getResponse();
        if (res.getStatusCode() == 487) {
            ct = null;
        }
    }

    private StatusCode getStatusCode(int code) {
        String c = String.valueOf(code);
        if (c.indexOf("1") == 0) {
            return StatusCode.CODE1xx;
        }
        if (c.indexOf("2") == 0) {
            return StatusCode.CODE2xx;
        }
        if (c.indexOf("3") == 0) {
            return StatusCode.CODE3xx;
        }
        if (c.indexOf("4") == 0) {
            return StatusCode.CODE4xx;
        }
        if (c.indexOf("5") == 0) {
            return StatusCode.CODE5xx;
        }
        if (c.indexOf("6") == 0) {
            return StatusCode.CODE6xx;
        }
        throw new IllegalAccessError("Invalid Response code!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StatusCode {
        CODE1xx,
        CODE2xx,
        CODE3xx,
        CODE4xx,
        CODE5xx,
        CODE6xx;

    }
}

